#include "../hed/hed_common/stl.h"
#include <windows.h>
#include <stdio.h>
#include "../hed/hed_picturelib/plimage.h"
#include "plg_filter.h"

// ϊ̉摜TCYvZ֐
bool calc_new_size( CPLImage *in, resize_picture_option *pOption, int &nNewSizeW, int &nNewSizeH )
{
	int inWidth = 0, inHeight = 0;
	in->GetImageSize( inWidth, inHeight );

	double fSizeW = (double)inWidth;
	double fSizeH = (double)inHeight;
	double percent = 1.0;
	if( pOption->new_size == 0 )
		return false;

	switch( pOption->type )
	{
	case E_PERCENT:
		{
			percent = (double)( pOption->new_size ) / 100.00;
			nNewSizeW = (int)(fSizeW * percent);
			nNewSizeH = (int)(fSizeH * percent);
		}
		break;
	case E_NEWSIZE_PIXEL:
		{
			double nWidth = (double)(LOWORD( pOption->new_size ));
			double nHeight = (double)(HIWORD( pOption->new_size ));
			if( nWidth / fSizeW < nHeight / fSizeH )
			{
				percent = nWidth / fSizeW;
				nNewSizeW = (int)nWidth;
				nNewSizeH = (int)(fSizeH * percent);
			}
			else
			{
				percent = nHeight / fSizeH;
				nNewSizeH = (int)nHeight;
				nNewSizeW = (int)(fSizeW * percent);
			}
		}
		break;
	default:
		return false;
	}
	return true;
}

// 摜g/k֐(Ԗ)
bool resize_picture_lv1( CPLImage *out, CPLImage *in )
{
	int inWidth = 0, inHeight = 0;
	in->GetImageSize( inWidth, inHeight);
	int outWidth = 0, outHeight = 0;
	out->GetImageSize( outWidth, outHeight );

	int w = 0, h = 0;
	int wOrg = 0, hOrg = 0;
	int nNewSizeW = outWidth, nNewSizeH = outHeight;
	double percent = (double)(inWidth) / (double)(outWidth);
	
	for( h = 0; h < nNewSizeH; h ++ )
	{
		hOrg = (int)((double)(h) * percent);
		for( w = 0; w < nNewSizeW; w ++ )
		{
			wOrg = (int)((double)(w) * percent);
			COLORREF crIn;
			in->GetImagePixel( wOrg, hOrg, crIn );
			out->SetImagePixel( w, h, crIn );
		}
	}
	return true;
}

// 摜k(Ԃ)
bool resize_down_picture_lv2( CPLImage *out, CPLImage *in )
{
	int inWidth = 0, inHeight = 0;
	in->GetImageSize( inWidth, inHeight );
	int outWidth = 0, outHeight = 0;
	out->GetImageSize( outWidth, outHeight );

	double percent = (double)(inWidth) / (double)(outWidth);
	int nNewHeight = outHeight, nNewWidth = outWidth;
	double dStartPosX = 0.0, dEndPosX = 0.0;
	double dStartPosY = 0.0, dEndPosY = 0.0;
	int nStartPosX = 0, nEndPosX = 0;
	int nStartPosY = 0, nEndPosY = 0;

	COLORREF *imageLineOut = 
		( COLORREF * )malloc( sizeof( COLORREF ) * outWidth );

	for( int h = 0; h < nNewHeight; h ++ )
	{
		dStartPosY = (double)(h) * percent + 0.5;
		dEndPosY = (double)(h+1) * percent + 0.5;
		nStartPosY = (int)(dStartPosY);
		nEndPosY = (int)(dEndPosY);
		for( int w = 0; w < nNewWidth; w ++ )
		{
			int r = 0, g = 0, b = 0;
			dStartPosX = (double)(w) * percent + 0.5;
			dEndPosX = (double)(w+1) * percent + 0.5;
			nStartPosX = (int)(dStartPosX);
			nEndPosX = (int)(dEndPosX);
			int size = ( nEndPosX-nStartPosX + 1 )*( nEndPosY-nStartPosY + 1 );
			if( size == 0 ) size = 1;
			for( int y = nStartPosY; y <= nEndPosY; y ++ )
			{
				for( int x = nStartPosX; x <= nEndPosX; x ++ )
				{
					COLORREF crValue = RGB( 0, 0, 0 );
					in->GetImagePixel( x, y, crValue );
					r += GetRValue( crValue );
					g += GetGValue( crValue );
					b += GetBValue( crValue );
				}
			}
			imageLineOut[w] = RGB( r / size, g / size, b / size );
		}
		out->SetImageLine( h, ( unsigned char * )imageLineOut );
	}
	free( imageLineOut );
	return true;
}

// 摜g(Ԃ)
bool resize_up_picture_lv2( CPLImage *out, CPLImage *in )
{
	int inWidth = 0, inHeight = 0;
	in->GetImageSize( inWidth, inHeight );
	int outWidth = 0, outHeight = 0;
	out->GetImageSize( outWidth, outHeight );
	COLORREF *imageLineTop = NULL, *imageLineBottom = NULL;
	COLORREF *imageLineOut = NULL;

	const double xPercent = (double)(inWidth) / (double)(outWidth);
	const double yPercent = (double)(inHeight) / (double)(outHeight);
	
	imageLineTop = 
		( COLORREF * )malloc( sizeof( COLORREF ) * inWidth );
	imageLineBottom = 
		( COLORREF * )malloc( sizeof( COLORREF ) * inWidth );
	imageLineOut = 
		( COLORREF * )malloc( sizeof( COLORREF ) * outWidth );

	int nnyOrgPrevious = -1;
	for( int h = 0; h < outHeight; h ++ )
	{
		const double yOrg = (double)(h) * yPercent;
		const double nyOrg = (int)(yOrg);
		const int nnyOrg = (int)nyOrg;
		const double ySabun = yOrg - nyOrg;
		const double ySabunBar = 1.0 - ySabun;
		if( nnyOrgPrevious != nnyOrg )
		{
			in->GetImageLine( nnyOrg, (unsigned char**)&imageLineTop, FALSE );
			in->GetImageLine( nnyOrg + 1, (unsigned char**)&imageLineBottom, FALSE );
			nnyOrgPrevious = nnyOrg;
		}
		for( int w = 0; w < outWidth; w ++ )
		{
			const double xOrg = (double)(w) * xPercent;
			const double nxOrg = (int)(xOrg);
			const int nnxOrg = (int)nxOrg;
			const double xSabun = xOrg - nxOrg;
			const double xSabunBar = 1.0 - xSabun;
			COLORREF x1y1 = RGB( 0, 0, 0 ),
					x2y1 = RGB( 0, 0, 0 ),
					x1y2 = RGB( 0, 0, 0 ),
					x2y2 = RGB( 0, 0, 0 );
			x1y1 = imageLineTop[nnxOrg];
			x1y2 = imageLineBottom[nnxOrg];
			if( nnxOrg + 1 == inWidth )
			{
				x2y1 = x1y1;
				x2y2 = x1y2;
			}
			else
			{
				x2y1 = imageLineTop[nnxOrg+1];
				x2y2 = imageLineBottom[nnxOrg+1];
			}
			const COLORREF y1 = RGB( 
				GetRValue( x1y1 ) * xSabunBar + GetRValue( x2y1 ) * xSabun,
				GetGValue( x1y1 ) * xSabunBar + GetGValue( x2y1 ) * xSabun,
				GetBValue( x1y1 ) * xSabunBar + GetBValue( x2y1 ) * xSabun );
			const COLORREF y2 = RGB( 
				GetRValue( x1y2 ) * xSabunBar + GetRValue( x2y2 ) * xSabun,
				GetGValue( x1y2 ) * xSabunBar + GetGValue( x2y2 ) * xSabun,
				GetBValue( x1y2 ) * xSabunBar + GetBValue( x2y2 ) * xSabun );
			const COLORREF cr = RGB(
				GetRValue( y1 ) * ySabunBar + GetRValue( y2 ) * ySabun,
				GetGValue( y1 ) * ySabunBar + GetGValue( y2 ) * ySabun,
				GetBValue( y1 ) * ySabunBar + GetBValue( y2 ) * ySabun );
			imageLineOut[w] = cr;
		}
		out->SetImageLine( h, ( unsigned char * )imageLineOut );
	}
	free( imageLineOut );
	free( imageLineTop );
	free( imageLineBottom );
	return true;
}

// 摜gEk̂߂̃C֐
bool resize_picture( CPLImage *in, CPLImage *out, resize_picture_option *pOption )
{
	int inWidth = 0, inHeight = 0;
	in->GetImageSize( inWidth, inHeight );

	int nNewSizeH = 0, nNewSizeW = 0;
	if ( !calc_new_size( in, pOption, nNewSizeW, nNewSizeH ) )
		return NULL;

	out->RenewalImage( nNewSizeW, nNewSizeH, 24 );

	bool bResult = false;
	if( pOption->value == 0 )
	{
		bResult = resize_picture_lv1( out, in );
	}
	else
	{
		if( inWidth < nNewSizeW )
			bResult = resize_up_picture_lv2( out, in );
		else
			bResult = resize_down_picture_lv2( out, in );
	}

	if( !bResult )
	{
		out->DestroyImage();
	}
	return true;
}

// ėptB^ckk֐
__declspec(dllexport) bool __stdcall do_filter( CPLImage *in, CPLImage *out, void *pOption )
{
	if( !in || !out || !pOption )
		return NULL;

	resize_picture_option *pResizeOption = ( resize_picture_option *)pOption;
	return resize_picture( in, out, (resize_picture_option*)pOption );
}