#include "../hed/hed_common/stl.h"
#include <windows.h>
#include <stdio.h>
#include "hash.h"
#include "plg_reducecolor.h"
#include "../hed/hed_picturelib/plimage.h"

// ̏s
reduce_info * initialize( CPLImage *pImageIn, CPLImage *pImageOut, reduce_color_option *pOption )
{
	if( !pImageIn || !pImageOut || !pOption )
		return NULL;

	int inWidth = 0, inHeight = 0, inColordepth = 0;
	pImageIn->GetImageSize( inWidth, inHeight );
	pImageIn->GetImageColorDepth( inColordepth );
	if( inWidth <= 0 || inHeight <= 0 )
		return NULL;

	// IvVp[^`FbN
	if( pOption->ucUsePalette == 0 )
		pOption->ucUsePalette = 256;
	else if( pOption->ucUsePalette > 256 )
		pOption->ucUsePalette = 256;

	// 摜Fp\̐
	reduce_info *pInfo = new reduce_info;
	memset( pInfo, 0x00, sizeof( reduce_info ) );
	// ͏ݒ
	pInfo->hInputImage = pImageIn;
	pInfo->pReduceOption = pOption;
	pInfo->width = inWidth;
	pInfo->height = inHeight;

	// o̓C[Ŵ߂̃[蓖
	pInfo->hOutputImage = pImageOut;
	pImageOut->RenewalImage( inWidth, inHeight, 8 );

	// f[^
	pInfo->nUseColorCount = 0;

	// f[^̊蓖
	pInfo->pHistgramHash = new CHash( 0x10000 );
	pInfo->pHistgram = NULL;
	pInfo->pBox = new COLOR_BOX[pOption->ucUsePalette];
	pInfo->pOutputPalette = new RGBQUAD[pOption->ucUsePalette];
	memset( pInfo->pBox, 0x00, sizeof( COLOR_BOX ) * pOption->ucUsePalette );
	memset( pInfo->pOutputPalette, 0x00, sizeof( RGBQUAD ) * pOption->ucUsePalette );

	return pInfo;
}

// f[^̌ns
void terminate( reduce_info *pInfo )
{
	if( !pInfo )
		return;
	// [̉
	delete pInfo->pHistgramHash;
	delete pInfo->pHistgram;
	delete[] pInfo->pBox;
	delete[] pInfo->pOutputPalette;
	delete pInfo;
}

// 摜XLāAFe[u쐬
bool create_histgram( reduce_info *pInfo )
{
	if( !pInfo->pHistgramHash || 
		!pInfo->hInputImage )
		return false;

	int nColorCount = 0;
	int width = pInfo->width;
	int height = pInfo->height;
	CHash *prgbHash = pInfo->pHistgramHash;
	for( int ch = 0; ch < height; ch ++ )
	{
		for( int cw = 0; cw < width; cw ++ )
		{
			COLORREF crValue = RGB( 0, 0, 0 );
			pInfo->hInputImage->GetImagePixel( cw, ch, crValue );
			if( prgbHash->inc_rgb_count( crValue ) == 1 )
				nColorCount++;
		}
	}
	pInfo->nUseColorCount = nColorCount;
	pInfo->pHistgram = new COLOR_HISTGRAM[nColorCount];
	return true;
}

// Map  Array ɕϊ
bool dump_histgram_to_array( reduce_info *pInfo )
{
	CHash *hash = pInfo->pHistgramHash;
	COLOR_HISTGRAM *rgbArray = pInfo->pHistgram;
	if( !hash ||
		!rgbArray )
		return false;

	for( unsigned int i = 0; i < hash->m_nTableSize; i++ )
	{
		SSingleList *pList = hash->m_pTable[i];
		while( pList )
		{
			rgbArray->rgbValue = pList->m_colorRef;
			rgbArray->uiUsed = pList->m_value;
			pList = pList->m_next;
			rgbArray ++;
		}
	}
	return true;
}

// ׂ BOX T(Fgpő̂)
COLOR_BOX *scan_divide_box( COLOR_BOX *pBox, int nBoxNum )
{
	int nMax = 0;
	int nDivideBoxNumber = 0;
	COLOR_BOX *pBoxResult = NULL;
	for( int i = 0; i < nBoxNum; i++ )
	{
		if( pBox[i].colors > nMax )
		{
			if( pBox[i].colors > 1 )
			{
				pBoxResult = &pBox[i];
				nDivideBoxNumber = i;
				nMax = pBox[i].colors;
			}
		}
	}
	return pBoxResult;
}

// w肳ꂽBOX̍Œӂ
void get_longest_line( COLOR_HISTGRAM *pHistgram, COLOR_BOX *pDivideBox, int *oMin, int *oMax, int *orgbType )
{
	BYTE rMin = 255, rMax = 0, gMin = 255, gMax = 0, bMin = 255, bMax = 0;
	for( int i = 0; i < pDivideBox->colors; i++ )
	{
		BYTE r = GetRValue( pHistgram[pDivideBox->start + i].rgbValue );
		BYTE g = GetGValue( pHistgram[pDivideBox->start + i].rgbValue );
		BYTE b = GetBValue( pHistgram[pDivideBox->start + i].rgbValue );
		if( rMin > r ) rMin = r;
		if( rMax < r ) rMax = r;
		if( gMin > r ) gMin = g;
		if( gMax < r ) gMax = g;
		if( bMin > r ) bMin = b;
		if( bMax < r ) bMax = b;
	}
	if( ( rMax - rMin > gMax - gMin ) )
	{
		if ( rMax - rMin > bMax - bMin )
		{
			*oMax = rMax;
			*oMin = rMin;
			*orgbType = 0;
		}
		else
		{
			*oMax = bMax;
			*oMin = bMin;
			*orgbType = 2;
		}
	}
	else if( bMax - bMin > gMax - gMin )
	{
		*oMax = bMax;
		*oMin = bMin;
		*orgbType = 2;
	}
	else
	{
		*oMax = gMax;
		*oMin = gMin;
		*orgbType = 1;
	}
}

// Rl̑傫ȏɃ\[gs(qsort callback)
int qsort_r( const void *arg1, const void *arg2 )
{
	COLOR_HISTGRAM *ref1 = (COLOR_HISTGRAM*)arg1;
	COLOR_HISTGRAM *ref2 = (COLOR_HISTGRAM*)arg2;
	if( GetRValue( ref1->rgbValue ) > GetRValue( ref2->rgbValue ) )
		return 1;
	else if( GetRValue( ref1->rgbValue ) < GetRValue( ref2->rgbValue ) )
		return -1;
	else
		return 0;
}

// Gl̑傫ȏɃ\[gs(qsort callback)
int qsort_g( const void *arg1, const void *arg2 )
{
	COLOR_HISTGRAM *ref1 = (COLOR_HISTGRAM*)arg1;
	COLOR_HISTGRAM *ref2 = (COLOR_HISTGRAM*)arg2;
	if( GetGValue( ref1->rgbValue ) > GetGValue( ref2->rgbValue ) )
		return 1;
	else if( GetGValue( ref1->rgbValue ) < GetGValue( ref2->rgbValue ) )
		return -1;
	else
		return 0;
}

// Bl̑傫ȏɃ\[gs(qsort callback)
int qsort_b( const void *arg1, const void *arg2 )
{
	COLOR_HISTGRAM *ref1 = (COLOR_HISTGRAM*)arg1;
	COLOR_HISTGRAM *ref2 = (COLOR_HISTGRAM*)arg2;
	if( GetBValue( ref1->rgbValue ) > GetBValue( ref2->rgbValue ) )
		return 1;
	else if( GetBValue( ref1->rgbValue ) < GetBValue( ref2->rgbValue ) )
		return -1;
	else
		return 0;
}

// BOX ̏lݒ
bool box_initialize( reduce_info *pInfo )
{
	int nMax = pInfo->nUseColorCount;
	COLOR_BOX *pBox = pInfo->pBox;
	pBox->start = 0;
	pBox->colors = pInfo->nUseColorCount;
	for( int i = 0; i < nMax; i++ )
		pBox->colornum += pInfo->pHistgram[i].uiUsed;
	return true;
}

// Œӕ
bool median_cut( reduce_info *pInfo, int nCurrent )
{
	COLOR_HISTGRAM *pHistgram = pInfo->pHistgram;
	COLOR_BOX *pBox = pInfo->pBox;
	int oMin = 0, oMax = 0, orgbType = 0, i = 0;

	COLOR_BOX *pDivideBox = scan_divide_box( pBox, nCurrent );
	if( !pDivideBox )
		return false;

	get_longest_line( pHistgram, pDivideBox, &oMin, &oMax, &orgbType ); 
	if( orgbType == 0 )
		qsort( &pHistgram[pDivideBox->start], pDivideBox->colors, sizeof( COLOR_HISTGRAM ), qsort_r );
	else if( orgbType == 1 )
		qsort( &pHistgram[pDivideBox->start], pDivideBox->colors, sizeof( COLOR_HISTGRAM ), qsort_g );
	else if( orgbType == 2 )
		qsort( &pHistgram[pDivideBox->start], pDivideBox->colors, sizeof( COLOR_HISTGRAM ), qsort_b );

	int nColorCount = 0;
	for( i = 0; i < pDivideBox->colors - 1; i++ )
	{
		nColorCount += pHistgram[pDivideBox->start+i].uiUsed;
		if( nColorCount >= pDivideBox->colornum / 2)
		{
			i++;
			break;
		}
	}
	pBox[nCurrent].colornum = pDivideBox->colornum - nColorCount;
	pBox[nCurrent].start = pDivideBox->start + i;
	pBox[nCurrent].colors = pDivideBox->colors - i;
	pDivideBox->colornum = nColorCount;
	pDivideBox->colors = i;
	return true;		
}

// œKpbg̍쐬
bool generate_palette( reduce_info *pInfo )
{
	int nTotal = 0, cnt = 0;
	COLOR_HISTGRAM *pHistgram = pInfo->pHistgram;
	COLOR_BOX *pBox = pInfo->pBox;
	RGBQUAD *pRGB = pInfo->pOutputPalette;
	int nColorNum = pInfo->pReduceOption->ucUsePalette;

	for( int pal = 0; pal < nColorNum; pal ++ )
	{
		nTotal = 0;
		// RedZo
		qsort( &(pHistgram[pBox->start]), pBox->colors, sizeof( COLOR_HISTGRAM ), qsort_r );
		for( cnt = 0; cnt < pBox->colors; cnt ++ )
		{
			nTotal += pHistgram[pBox->start + cnt].uiUsed;
			if( nTotal > pBox->colornum / 2 )
				break;
		}
		pRGB[pal].rgbRed = GetRValue( pHistgram[pBox->start + cnt].rgbValue );
		// GreenZo
		nTotal = 0;
		qsort( &(pHistgram[pBox->start]), pBox->colors, sizeof( COLOR_HISTGRAM ), qsort_g );
		for( cnt = 0; cnt < pBox->colors; cnt ++ )
		{
			nTotal += pHistgram[pBox->start + cnt].uiUsed;
			if( nTotal > pBox->colornum / 2 )
				break;
		}
		pRGB[pal].rgbGreen = GetGValue( pHistgram[pBox->start + cnt].rgbValue );
		// BlueZo
		nTotal = 0;
		qsort( &(pHistgram[pBox->start]), pBox->colors, sizeof( COLOR_HISTGRAM ), qsort_b );
		for( cnt = 0; cnt < pBox->colors; cnt ++ )
		{
			nTotal += pHistgram[pBox->start + cnt].uiUsed;
			if( nTotal > pBox->colornum / 2 )
				break;
		}
		pRGB[pal].rgbBlue = GetBValue( pHistgram[pBox->start + cnt].rgbValue );
		pBox ++;
		if( pBox->colors == 0 )
			break;
	}
	return true;
}

// œKȃpbg
unsigned char __fastcall search_best_palette( COLORREF currentBit, RGBQUAD *pPalette, int nPaletteNumber )
{
	int nBestPalette = 0;
	int nMinColorLength = 0x7fffffff;
	unsigned char r = GetRValue(currentBit);
	unsigned char g = GetGValue( currentBit );
	unsigned char b = GetBValue( currentBit );

	for( int i = 0; i < nPaletteNumber; i ++ )
	{
		int r2 = r - pPalette->rgbRed,
			g2 = g - pPalette->rgbGreen,
			b2 = b - pPalette->rgbBlue;
		if( r2 + g2 + b2 < nMinColorLength )
		{
			int nLength = r2 * r2 + g2 * g2 + b2 * b2;
			if( nLength < nMinColorLength )
			{
				nMinColorLength = nLength;
				nBestPalette = i;
			}
			if( nLength == 0 )
				break;
		}
		pPalette ++;
	}
	return nBestPalette;
}

// 덷gUȂo̓C[W쐬
bool make_output_image_floyd_steinberg( reduce_info *pInfo )
{
	const int nPower = 24;
	int nPaletteNumber = pInfo->pReduceOption->ucUsePalette;
	int width = pInfo->width;
	int height = pInfo->height;
	RGBQUAD *pPalette = pInfo->pOutputPalette;
	int *sub_info_r1 = new int[ width + 2];
	int *sub_info_g1 = new int[ width + 2];
	int *sub_info_b1 = new int[ width + 2];
	int *sub_info_r2 = new int[ width + 2];
	int *sub_info_g2 = new int[ width + 2];
	int *sub_info_b2 = new int[ width + 2];
	memset( sub_info_r1, 0x00, sizeof( int ) * (width + 2) );
	memset( sub_info_g1, 0x00, sizeof( int ) * (width + 2) );
	memset( sub_info_b1, 0x00, sizeof( int ) * (width + 2) );
	memset( sub_info_r2, 0x00, sizeof( int ) * (width + 2) );
	memset( sub_info_g2, 0x00, sizeof( int ) * (width + 2) );
	memset( sub_info_b2, 0x00, sizeof( int ) * (width + 2) );
	sub_info_r1 ++;
	sub_info_g1 ++;
	sub_info_b1 ++;
	sub_info_r2 ++;
	sub_info_g2 ++;
	sub_info_b2 ++;
	for( int h = 0; h < height; h ++ )
	{
		int *rBuffer = sub_info_r1;
		int *gBuffer = sub_info_g1;
		int *bBuffer = sub_info_b1;
		sub_info_r1 = sub_info_r2;
		sub_info_g1 = sub_info_g2;
		sub_info_b1 = sub_info_b2;
		sub_info_r2 = rBuffer;
		sub_info_g2 = gBuffer;
		sub_info_b2 = bBuffer;
		memset( sub_info_r2-1, 0x00, sizeof( int ) * (width + 2) );
		memset( sub_info_g2-1, 0x00, sizeof( int ) * (width + 2) );
		memset( sub_info_b2-1, 0x00, sizeof( int ) * (width + 2) );

		int w = 0;
		if( h % 2 )
			w = width - 1;
		else
			w = 0;
		do
		{
			// ݂Bit擾
			COLORREF currentBit = RGB( 0, 0, 0 );
			pInfo->hInputImage->GetImagePixel( w, h, currentBit );

			// 덷ǉ
			int cur_r = GetRValue( currentBit );
			int cur_g = GetGValue( currentBit );
			int cur_b = GetBValue( currentBit );
			if( sub_info_r1[w] > 0 )
				sub_info_r1[w] -= nPower / 2;
			else
				sub_info_r1[w] += nPower / 2;
			if( sub_info_g1[w] > 0 )
				sub_info_g1[w] -= nPower / 2;
			else
				sub_info_g1[w] += nPower / 2;
			if( sub_info_b1[w] > 0 )
				sub_info_b1[w] -= nPower / 2;
			else
				sub_info_b1[w] += nPower / 2;
			cur_r += sub_info_r1[w] / nPower;
			cur_g += sub_info_g1[w] / nPower;
			cur_b += sub_info_b1[w] / nPower;
			if( cur_r < 0 ) cur_r = 0;
			else if( cur_r > 255 ) cur_r = 255;
			if( cur_g < 0 ) cur_g = 0;
			else if( cur_g > 255 ) cur_g = 255;
			if( cur_b < 0 ) cur_b = 0;
			else if( cur_b > 255 ) cur_b = 255;
			currentBit = RGB( cur_r, cur_g, cur_b );

			// œKpbg
			unsigned char paletteID = search_best_palette( currentBit, pPalette, nPaletteNumber );
			pInfo->hOutputImage->SetImagePixel( w, h, paletteID );

			// 덷gU
			int r_delta = GetRValue( currentBit ) - pPalette[paletteID].rgbRed;
			int g_delta = GetGValue( currentBit ) - pPalette[paletteID].rgbGreen;
			int b_delta = GetBValue( currentBit ) - pPalette[paletteID].rgbBlue;
			if( h % 2 )
			{
				sub_info_r1[w - 1] += r_delta * 7;
				sub_info_g1[w - 1] += g_delta * 7;
				sub_info_b1[w - 1] += b_delta * 7;
				sub_info_r2[w + 1] += r_delta * 3;
				sub_info_g2[w + 1] += g_delta * 3;
				sub_info_b2[w + 1] += b_delta * 3;
				sub_info_r2[w] += r_delta * 5;
				sub_info_g2[w] += g_delta * 5;
				sub_info_b2[w] += b_delta * 5;
				sub_info_r2[w - 1] += r_delta;
				sub_info_g2[w - 1] += g_delta;
				sub_info_b2[w - 1] += b_delta;
			}
			else
			{
				sub_info_r1[w + 1] += r_delta * 7;
				sub_info_g1[w + 1] += g_delta * 7;
				sub_info_b1[w + 1] += b_delta * 7;
				sub_info_r2[w - 1] += r_delta * 3;
				sub_info_g2[w - 1] += g_delta * 3;
				sub_info_b2[w - 1] += b_delta * 3;
				sub_info_r2[w] += r_delta * 5;
				sub_info_g2[w] += g_delta * 5;
				sub_info_b2[w] += b_delta * 5;
				sub_info_r2[w + 1] += r_delta;
				sub_info_g2[w + 1] += g_delta;
				sub_info_b2[w + 1] += b_delta;
			}

			if( h % 2 )
				w--;
			else
				w ++;
		}while ( w >= 0 && w < width );
	}
	sub_info_r1 --;
	sub_info_g1 --;
	sub_info_b1 --;
	sub_info_r2 --;
	sub_info_g2 --;
	sub_info_b2 --;
	delete[] sub_info_r1;
	delete[] sub_info_g1;
	delete[] sub_info_b1;
	delete[] sub_info_r2;
	delete[] sub_info_g2;
	delete[] sub_info_b2;
	return true;
}

// 摜F̂߂̃C֐
bool reduce_color( CPLImage *pImageIn, CPLImage *pImageOut, reduce_color_option *option )
{
	reduce_info *info = initialize( pImageIn, pImageOut, option );
	if( !info )
		return NULL;

	create_histgram( info );
	dump_histgram_to_array( info );
	box_initialize( info );
	for( int i = 1; i < option->ucUsePalette - 1; i ++ )
	{
		if( !median_cut( info, i ) )
			break;
	}
	generate_palette( info );
	make_output_image_floyd_steinberg( info );

	for( int cnt = 0; cnt < info->pReduceOption->ucUsePalette; cnt ++ )
	{
		RGBQUAD *pRGB = &info->pOutputPalette[cnt];
		info->hOutputImage->SetImagePalette( cnt, RGB( pRGB->rgbRed, pRGB->rgbGreen, pRGB->rgbBlue ) );
	}
	terminate( info );

	return true;
}

// ėptB^ckk֐
__declspec(dllexport) bool __stdcall do_filter( CPLImage *in, CPLImage *out, void *pOption )
{
	reduce_color_option defaultOption;
	if( pOption == NULL )
	{
		defaultOption.ucUsePalette = 256;
		pOption = &defaultOption;
	}
	return reduce_color( in, out, (reduce_color_option *)pOption );
}