#include "../hed/hed_common/stl.h"
#include"../hed/hed_picturelib/filter.h"
#include "../hed/hed_picturelib/plmemoryimage.h"

CPLMemoryImage::CPLMemoryImage(void)
{
	init ( );
}

CPLMemoryImage::~CPLMemoryImage(void)
{
	DestroyImage( );
}

// \zE
CPLMemoryImage * __fastcall CPLMemoryImage::Create( )
{
	return new CPLMemoryImage;
}

void __fastcall CPLMemoryImage::init( )
{
	CPLImage::init( );
	m_pImageData = NULL;
}

// 
bool __fastcall CPLMemoryImage::CreateImage( TCHAR *strImageName, int width, int height, int colordepth )
{
	if( CPLImage::CreateImage( strImageName, width, height, colordepth ) == false )
		return false;

	switch( colordepth )
	{
	case 8:
		m_pImageData = (unsigned char *)PL_Malloc( width*height, true );
		break;
	case 24:
		m_pImageData = (unsigned char *)PL_Malloc( width*height*sizeof(COLORREF), true );
		break;
	default:
		return false;
	}
	return true;
}

bool CPLMemoryImage::HasObject( )
{
	return ( m_pImageData != NULL );
}

// 
CPLImage * __fastcall CPLMemoryImage::Clone( TCHAR *strNewImageName )
{
	if( !HasObject() || !strNewImageName )
		return NULL;
	
	CPLMemoryImage *pResult = CPLMemoryImage::Create( );
	pResult->CreateImage( m_ObjectName, m_Width, m_Height, m_ColorDepth );
	
	memcpy( pResult->m_Palette, m_Palette, sizeof( COLORREF ) * 256 );
	int nImageSize = m_Width * m_Height * ( ( m_ColorDepth == 8 ) ? 1 : 4 );
	memcpy( pResult->m_pImageData, m_pImageData, nImageSize );
	
	return pResult;
}

// j
void __fastcall CPLMemoryImage::DestroyImage( )
{
	PL_Free( m_pImageData );
	init( );
}

// 擾
bool __fastcall CPLMemoryImage::GetImagePixel( int width, int height, COLORREF &crResult )
{
	crResult = RGB( 0, 0, 0 );

	if( !m_pImageData )
		return false;
	if( width < 0 ) width = 0;
	if( height < 0 ) height = 0;
	if( width >= m_Width ) width = m_Width - 1;
	if( height >= m_Height ) height = m_Height - 1;

	if( m_ColorDepth == 8 )
		return false;

	COLORREF *pImageData = (COLORREF*)m_pImageData;
	COLORREF *pcrImage = (COLORREF*)m_pImageData;
	crResult = pcrImage[m_Width * height + width];
	return true;
}

bool __fastcall CPLMemoryImage::GetImagePixel( int width, int height, unsigned char &paletteIndex )
{
	paletteIndex = 0;

	if( !m_pImageData )
		return false;
	if( width < 0 ) width = 0;
	if( height < 0 ) height = 0;
	if( width >= m_Width ) width = m_Width - 1;
	if( height >= m_Height ) height = m_Height - 1;

	if( m_ColorDepth == 8 )
	{
		paletteIndex = m_pImageData[m_Width * height + width];
		return true;
	}
	return false;
}

bool __fastcall CPLMemoryImage::GetImageLine( int nLine, unsigned char **ppResult, BOOL bPaletteIndex )
{
	if( !m_pImageData )
		return false;
	if( nLine >= m_Height ) nLine = m_Height - 1;
	else if( nLine < 0 ) nLine = 0;

	int nReadPos = 0;
	int nReadSize = 0;
	if( m_ColorDepth == 8 )
	{
		nReadPos = m_Width * nLine;
		nReadSize = m_Width;
		if( !bPaletteIndex )
		{
			nReadPos *= 4;
			nReadSize *= 4;
		}
	}
	else if( m_ColorDepth == 24 )
	{
		nReadPos += m_Width * nLine * 4;
		nReadSize = m_Width * 4;
	}

	if( !*ppResult )
		*ppResult = (unsigned char*)::PL_Malloc( nReadSize, false );

	if( m_ColorDepth != 8 || bPaletteIndex )
	{
		unsigned char *pSource = m_pImageData + nReadPos;
		unsigned char *pTarget = *ppResult;
		memcpy( pTarget, pSource, nReadSize );
	}
	else
	{
		unsigned char *pixCurLine = m_pImageData + nLine * m_Width;
		COLORREF *pixSetCurLine = (COLORREF*)*ppResult;
		for( int cnt = 0; cnt < m_Width; cnt ++ )
		{
			COLORREF crSetColor = m_Palette[pixCurLine[cnt]];
			pixSetCurLine[cnt] = crSetColor;
		}
	}
	return true;
}

// ݒ
bool __fastcall CPLMemoryImage::SetImagePixel( int width, int height, COLORREF crPixel )
{
	if( !m_pImageData )
		return false;
	if( width < 0 || height < 0 || width >= m_Width || height >= m_Height )
		return false;
	if( m_ColorDepth == 8 )
		return false;

	COLORREF *pcrImage = (COLORREF*)m_pImageData;
	*(pcrImage + height * m_Width + width) = crPixel;
	return true;
}

bool __fastcall CPLMemoryImage::SetImagePixel( int width, int height, unsigned char paletteNo )
{
	if( !m_pImageData )
		return false;
	if( width < 0 || height < 0 || width >= m_Width || height >= m_Height )
		return false;
	if( m_ColorDepth == 24 )
		return false;

	unsigned char *pImageData = m_pImageData + height * m_Width + width;
	*pImageData = paletteNo;
	return true;
}

bool __fastcall CPLMemoryImage::SetImageLine( int nLine, unsigned char *pLineData )
{
	if( !m_pImageData || !pLineData )
		return false;
	if( nLine < 0 ) 
		return false;
	else if( nLine > m_Height )
		return false;

	if( m_ColorDepth == 8 )
	{
		unsigned char *pTarget = m_pImageData + nLine * m_Width;
		memcpy( pTarget, pLineData, m_Width );
	}
	else if( m_ColorDepth == 24 )
	{
		unsigned long lLineWidth = m_Width * sizeof(COLORREF);
		unsigned char *pTarget = m_pImageData + nLine * lLineWidth;
		memcpy( pTarget, pLineData, lLineWidth );
	}
	return true;
}
