#pragma once

#undef _EXPORT_
#ifdef PIC_KERNEL_EXPORTS
#define _EXPORT_ __declspec(dllexport) 
#else
#define _EXPORT_ __declspec(dllimport) 
#endif

#include <tchar.h>

class CPLFileData;
class CPLMemoryData;

class _EXPORT_ CPLData
{
public:
	CPLData( const TCHAR * chObject );
	CPLData( const TCHAR * chObject, CPLFileData *);
	CPLData( const TCHAR * chObject, CPLMemoryData *);
	~CPLData(void);

	bool __fastcall is_file( );
	bool __fastcall is_memory( );
	bool __fastcall set_file( CPLFileData * );
	bool __fastcall set_memory( CPLMemoryData * );
	CPLFileData * __fastcall get_file( );
	CPLMemoryData * __fastcall get_memory( );
	void get_name( TCHAR *chName, const unsigned int nBufferLen );

	static const char *DEFAULT_OBJECT_NAME;

protected:
	CPLFileData *m_file;
	CPLMemoryData *m_memory;
	bool m_bAutoDelete;
	TCHAR m_chObjectName[256];
};
