// Place your application-specific JavaScript functions and classes here
// This file is automatically included by javascript_include_tag :defaults

var justifyHeight = function(){
    jQuery(function($){
        var left = $("div#leftcolumn").height();
        var right = $("div#rightcolumn").height();
        var min = $("div#leftcolumn").css("min-height").match(/(\d+)px/)[1];
        min = (new Number(min)).valueOf();
        if (min < left || min < right){
            if (left < right){
                $("div#leftcolumn").css("min-height", right);
            }
            if (right < left){
                $("div#rightcolumn").css("min-height", left);
            }
        }
    });
};

var plot = {
    init: function(svg){
        svg.plot.noDraw().area(0.1,0.1,0.9,0.9).format('ivory', 'gray').
            gridlines({ stroke: 'gray', strokeDashArray: '2.2'}, 'gray');
        svg.plot.noDraw().
            xAxis.scale(-10, 10).ticks(10, 5).end().
            yAxis.scale(-10, 10).ticks(10, 5).end().
            legend.settings({fill: 'lightgoldenrodyellow', stroke: 'gray'}).end().
            status(function(label){});
        svg.plot.noDraw().legend.show(true).area([0.005, 0, 0.8, 0.05]).end().
            equalXY(false);
        svg.plot.noDraw().addPoint('O', 0, 0, 1, 'black', true);
    },
    linear: function(a, b){
        return function(x){ return a * x + b; };
    }
};