# -*- coding: nil -*-

module Mint::Generator

  #
  # 整数の四則演算を生成するジェネレータ
  #
  # == オプション
  # [_term_number_]
  #   生成する式の項数を１以上の整数で指定します。
  # [_operators_]
  #   使用可能な演算子を指定します。
  #   +, -, *, div の４種類から使用したいものを配列で指定します。
  # [_min_]
  #   生成する式の各項の最小値を１以上の整数で指定します。
  # [_max_]
  #   生成する式の各項の最大値を１以上の整数で指定します。
  #   _min_ よりも小さい値を指定することは出来ません。
  # [_minus_]
  #   真を指定すると、負の値も生成します。
  #
  class OrdinaryArithmetic < Arithmetic

    private

    option :min,   0
    option :max,   100
    option :minus, true

    def operand
      integer
    end
  end
end

