# -*- coding: utf-8 -*-

module Mint::Generator

  #
  # 式展開の問題を生成するジェネレータ
  #
  # == オプション
  # [_order_min_]
  #   生成する方程式の次数の最小値を１以上の整数で指定します。
  # [_order_max_]
  #   生成する方程式の次数の最大値を１以上の整数で指定します。
  #   _order_min_ より小さい値を指定することは出来ません。
  # [_x_]
  #   使用可能な変数の文字を配列で指定します。
  #   文字列の代わりに配列の形で文字列のペアを
  #   指定すると、２変数を使用した式を生成します。
  # [_factor_min_]
  #   生成する式の各項の最小値を１以上の整数で指定します。
  # [_factor_max_]
  #   生成する式の各項の最大値を１以上の整数で指定します。
  #   _factor_min_ よりも小さい値を指定することは出来ません。
  # [_factor_minus_]
  #   真を指定すると、負も値を生成します。
  # [_coefficient_min_]
  #   係数の最小値を１以上の整数で指定します。
  # [_coefficient_max_]
  #   係数の最大値を１以上の整数で指定します。
  #   _coefficient_min_ より小さい値は指定できません。
  # [_coefficient_minus_]
  #   真を指定すると分母の係数として負の値を生成します。
  #
  class Expansion < HighOrderExpression

    private

    option :order_min,         2
    option :order_max,         3
    option :factor_min,        1
    option :factor_max,        100
    option :factor_minus,      true
    option :coefficient_min,   1
    option :coefficient_max,   1
    option :coefficient_minus, false

    def expression
      expansion
    end
  end
end

