module Mint::Solver::Simple

  class LinearFunctionGraph < ::Mint::Solver::Base
    def solve(problem) # :nodoc:
      answer = solve_problem(problem)
      Mint::Builder.build(answer)
    end
    private
    def solve_problem(problem)
      a = problem[:gradient]
      b = problem[:intercept]
      e = []
      if a.instance_of?(String)
        e << '(%1$s)x'
      else
        e << '%1$sx' unless a == 0
      end
      if b.instance_of?(String)
        e << '%2$s'
      else
        e << '%2$s'  unless b == 0
      end
      (e.join(" + ") % [a, b]).gsub(%r!\+ -!, '- ').gsub(/\A1x|([ -])1x/, '\1x')
    end
  end

end
