# -*- coding: utf-8 -*-

module Mint::Solver
  module Maxima

    def self.exec_maxima(expression)
      require 'open3'
      command = "maxima -r 'algebraic:true;display2d:false; #{expression};'"
      Open3.popen3(command) do |sin, sout, serr|
        sin.close
        result = sout.read
        unless /\(\%o3\)/ =~ result
          raise "maxima can't solve this problem: #{expression}"
        end
        result
      end
    end

    def self.equal?(target, other)
      result = exec_maxima("(#{target}) - (#{other})")
      return true if result == '0' || result == '0.0'
      # Retry using ratsimp
      result = exec_maxima("ratsimp((#{target}) - (#{other}))")
      result = result.match(/^\(%o3\)\s+(.*)$/)[1]
      result == '0' || result == '0.0'
    end
  end
end

require File.dirname(__FILE__) + '/maxima/base'
dir = File.dirname(__FILE__) + '/maxima/*'
Dir[dir].each do |engine|
  require engine
end

