
class MintExpressionParser
  prechigh
    right ROOT
    nonassoc UMINUS
    right '('
    left ')'
    right '^'
    left '/' '*'
    left DIV
    left '+' '-'
  preclow

  rule
    expression: exp | /* none */ { result = nil }

# NEED: RootNode
    exp: exp '+' exp            { result = Mint::AdditionNode.new(node(val[0]), node(val[2])) }
       | exp '-' exp            { result = Mint::SubtractionNode.new(node(val[0]), node(val[2])) }
       | exp '*' exp            { result = Mint::MultipleNode.new(node(val[0]), node(val[2])) }
       | exp '/' exp            { result = Mint::FractionNode.new(node(val[0]), add_parenthesis(node(val[2]))) }
       | exp '^' exp            { result = Mint::FactorialNode.new(node(val[0]), node(val[2])) }
       | exp DIV exp            { result = Mint::DivisionNode.new(node(val[0]), add_parenthesis(node(val[2]))) }
       | '(' exp ')'            { result = add_parenthesis(node(val[1])) }
       | '(' exp ')' '-' NUMBER { result = Mint::SubtractionNode.new(add_parenthesis(node(val[1])), node(val[4])) }
       | '-' NUMBER   =UMINUS   { result = minus(val[1]) }
       | '-' multiple =UMINUS   { result = minus(val[1]) }
       | ROOT '(' exp ')'       { result = Mint::RootNode.new(val[2]) }
       | multiple multiple      { result = Mint::MultipleNode.new(node(val[0]), node(val[1])) }
       | NUMBER multiple        { result = Mint::MultipleNode.new(node(val[0]), node(val[1])) }
       | minus multiple         { result = Mint::MultipleNode.new(node(val[0]), node(val[1])) }
       | '(' exp ')' exp        { result = Mint::MultipleNode.new(add_parenthesis(node(val[1])), val[3]) }
       | VARIABLE               { result = node(val[0]) }
       | NUMBER                 { result = node(val[0]) }

    multiple: '(' exp ')'       { result = add_parenthesis(node(val[1])) }
            | ROOT '(' exp ')'  { result = Mint::RootNode.new(val[2]) }
            | VARIABLE          { result = node(val[0]) }

    minus: '-' NUMBER   =UMINUS { result = minus(val[1]) }
         | '-' multiple =UMINUS { result = minus(val[1]) }

end

---- inner

def minus(val)
  case val
  when String
    result = node(val)
  else
    result = val
  end
  result.minus = true
  result
end

def node(val)
  if val.instance_of?(String)
    if /\d+\.\d+/ =~ val
      return Mint::DecimalNode.new(val)
    else
      return Mint::LiteralNode.new(val)
    end
  end
  val
end

def add_parenthesis(node)
  unless node.kind_of?(Mint::LiteralNode)
    node.parenthesis = true
  end
  node
end

def split_expression(str)
  str.gsub!(/(root\([^\)]\))(%?i)/, '\1 * \2')
  @q = []
  until str.empty?
    case str
    # blank
    when /\A\s+/

    # root
    when /\Aroot/, /\Asqrt/
      @q.push [:ROOT, $&]

    # PI
    when /\Api/, /\API/, /\A%pi/
      @q.push [:VARIABLE, '%pi']

    # e
    when /\AE/, /\Ae/, /\A%e/
      @q.push [:VARIABLE, '%e']

    # i
    when /\Ai/, /\A%i/
      @q.push [:VARIABLE, '%i']

    # division
    when /\Adiv/
      @q.push [:DIV, $&]

    # number
    when /\A\d+(\.\d+)?/
      @q.push [:NUMBER, $&]

    # float without point
    when /\A(\.\d+)/
      @q.push [:NUMBER, "0#{$&}"]

    # alphabet
    when /\A[a-zA-Z]+/
      # @q.push [:VARIABLE, $&]
      rest = $'
      s = $&.split(//).inject([]) {|m, t|
        m << [:VARIABLE, t]
        m << ['*', '*']
        m
      }
      s.pop
      @q.concat(s)
      str =~ /\A[a-zA-Z]+/

    # otherwise
    when /\A.|\n/o
      s = $&
      @q.push [s, s]
    end
    str = $'
  end
  @q
end

def parse(str)
  split_expression(str)
  @q.push [false, '$end']
  expression_tree = do_parse
  Mint::Expression.new(str, expression_tree)
end

def next_token
  @q.shift
end

