/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package info.projectkyoto.mms.assetmanager.common.playerconfig;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/**
 *
 * @author kobayasi
 */
public class MMSPlayerConfig implements Serializable{
    private String musicUri;
    private List<ModelMotion> modelMotionList;

    public MMSPlayerConfig() {
    }

    public MMSPlayerConfig(String musicUri, List<ModelMotion> modelMotionList) {
        this.musicUri = musicUri;
        this.modelMotionList = modelMotionList;
    }
    public MMSPlayerConfig(JSONObject json) throws JSONException {
        musicUri = json.getString("musicUri");
        JSONArray modelMotionArray = json.getJSONArray("modelMotionList");
        modelMotionList = new ArrayList<ModelMotion>();
        for(int i=0;i<modelMotionArray.length();i++) {
            JSONObject modelMotion = modelMotionArray.getJSONObject(i);
            modelMotionList.add(new ModelMotion(modelMotion));
        }
    }
    public JSONObject toJSonObject() throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("musicUri", musicUri);
        JSONArray modelMotionArray = new JSONArray();
        for(ModelMotion mm : modelMotionList) {
            modelMotionArray.put(mm.toJSONObject());
        }
        jsonObject.put("modelMotionList", modelMotionArray);
        return jsonObject;
    }

    public List<ModelMotion> getModelMotionList() {
        return modelMotionList;
    }

    public void setModelMotionList(List<ModelMotion> modelMotionList) {
        this.modelMotionList = modelMotionList;
    }

    public String getMusicUri() {
        return musicUri;
    }

    public void setMusicUri(String musicUri) {
        this.musicUri = musicUri;
    }
    
}
