/*
 * Decompiled with CFR 0.152.
 */
package org.rz.midiplayerplugin.renderer.pianoroll;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.io.File;
import java.util.ArrayList;
import java.util.logging.Level;
import org.rz.midiplayer.context.Context;
import org.rz.midiplayer.context.DefaultSimpleHandler;
import org.rz.midiplayer.midi.MidiEventListener;
import org.rz.midiplayer.plugin.renderer.SimpleRenderer;
import org.rz.midiplayer.util.PathUtil;
import org.rz.midiplayer.xmlmodule.JAXBUtil;
import org.rz.midiplayerplugin.renderer.pianoroll.NoteObject;
import org.rz.midiplayerplugin.renderer.pianoroll.NoteObjectPool;
import org.rz.midiplayerplugin.renderer.pianoroll.config.Color;
import org.rz.midiplayerplugin.renderer.pianoroll.config.Config;

public class PianorollRenderer
extends SimpleRenderer {
    private Context context;
    private final Dimension screenSize = new Dimension(512, 384);
    private DefaultSimpleHandler midiEventHandler;
    private final NoteObjectPool noteObjects = new NoteObjectPool(2048);
    private final ArrayList<NoteObject> noteList = new ArrayList(2048);
    public static final java.awt.Color[] DEFAULT_COLORS = new java.awt.Color[]{new java.awt.Color(8388564), new java.awt.Color(11591910), new java.awt.Color(16767673), new java.awt.Color(16752762), new java.awt.Color(10025880), new java.awt.Color(0xFFFF00), new java.awt.Color(16766720), new java.awt.Color(0xEE82EE), new java.awt.Color(15684210), new java.awt.Color(13789470), new java.awt.Color(64154), new java.awt.Color(0x7FFF00), new java.awt.Color(16113331), new java.awt.Color(16758465), new java.awt.Color(16716947), new java.awt.Color(49151), new java.awt.Color(12092939), new java.awt.Color(16737095)};
    private final java.awt.Color[] pianoRollColors = new java.awt.Color[16];

    public void onInit(Context ctx, String pluginDir) {
        this.context = ctx;
        this.midiEventHandler = new DefaultSimpleHandler(ctx){

            public void noteOff(int ch, int note) {
                PianorollRenderer.this.noteOff(ch, note);
            }

            public void noteOn(int ch, int note, int vel) {
                PianorollRenderer.this.noteOn(ch, note, vel);
            }
        };
        ctx.addMidiEventListener((MidiEventListener)this.midiEventHandler);
        try {
            for (int i = 0; i < 16; ++i) {
                this.pianoRollColors[i] = DEFAULT_COLORS[i];
            }
            JAXBUtil jaxbConfig = new JAXBUtil(Config.class);
            Config config = (Config)jaxbConfig.loadFromFile(PathUtil.package2ClasspathString(((Object)((Object)this)).getClass()) + "/config.xsd", PathUtil.buildPath((String)pluginDir, (String)"config.xml")).getValue();
            for (Color c : config.getPianoroll().getColor()) {
                try {
                    java.awt.Color col;
                    short ch = c.getMidich();
                    this.pianoRollColors[ch] = col = java.awt.Color.decode(c.getColor());
                }
                catch (Throwable e) {
                    logger.log(Level.WARNING, "Failed to loading a config file", e);
                }
            }
        }
        catch (Throwable e) {
            logger.log(Level.WARNING, "Failed to loading a config file", e);
        }
    }

    public Component getComponent() {
        Component c = super.getComponent();
        c.setPreferredSize(this.screenSize);
        return c;
    }

    public void onMidiPlayingBefore(File midiFile) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMidiStoped() {
        ArrayList<NoteObject> arrayList = this.noteList;
        synchronized (arrayList) {
            for (NoteObject o : this.noteList) {
                o.noteOff();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void noteOn(int ch, int noteNo, int vel) {
        ArrayList<NoteObject> arrayList = this.noteList;
        synchronized (arrayList) {
            NoteObject n = this.noteObjects.create();
            n.noteOn(472, 382 - 3 * noteNo);
            n.noteNo = noteNo;
            n.channel = ch;
            n.setColor(this.pianoRollColors[ch]);
            this.noteList.add(n);
        }
    }

    private synchronized void noteOff(int ch, int noteNo) {
        int s = this.noteList.size();
        for (int i = 0; i < s; ++i) {
            NoteObject n = this.noteList.get(i);
            if (n.channel != ch || n.noteNo != noteNo) continue;
            n.noteOff();
        }
    }

    public void onDispose(Context ctx) {
        ctx.removeMidiEventListener((MidiEventListener)this.midiEventHandler);
        super.onDispose(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        ArrayList<NoteObject> arrayList = this.noteList;
        synchronized (arrayList) {
            int i = 0;
            while (i < this.noteList.size()) {
                NoteObject n = this.noteList.get(i);
                if (n.rect.isEmpty()) {
                    this.noteList.remove(i);
                    continue;
                }
                n.update();
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(Graphics2D g) {
        g.setColor(java.awt.Color.black);
        g.fillRect(0, 0, this.screenSize.width, this.screenSize.height);
        ArrayList<NoteObject> arrayList = this.noteList;
        synchronized (arrayList) {
            for (NoteObject n : this.noteList) {
                n.render(g);
            }
        }
    }

    public boolean isEnabledResizeWindow() {
        return false;
    }
}

