/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import javax.swing.JLabel;

class TimeLabel
extends JLabel {
    public static final int TIME_POSITION = 0;
    public static final int TIME_LENGTH = 1;
    private int format_type;
    private int value_in_sec;

    public TimeLabel() {
        this(0);
    }

    public TimeLabel(int n) {
        this.format_type = n;
        this.value_in_sec = -1;
        if (n == 0) {
            float f = this.getFont().getSize2D() + 4.0f;
            this.setFont(this.getFont().deriveFont(f));
            this.setForeground(new Color(128, 0, 0));
            this.setText("00:00");
        } else {
            this.setText("/00:00");
        }
    }

    public void setTimeInMicrosecond(long l) {
        this.setTimeInSecond((int)(l / 1000000L));
    }

    public void setTimeInSecond(int n) {
        if (this.value_in_sec == n) {
            return;
        }
        this.value_in_sec = n;
        if (n < 0) {
            this.setText(null);
        } else if (this.format_type == 1) {
            this.setText(String.format("/%02d:%02d", n / 60, n % 60));
        } else {
            this.setText(String.format("%02d:%02d", n / 60, n % 60));
        }
    }
}

