/*
 * Decompiled with CFR 0.152.
 */
import java.util.List;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

class MidiDeviceTreeModel
implements TreeModel {
    List<MidiConnecterListModel> device_models;
    private static final MidiDeviceGroup root_node = new MidiDeviceGroup("MIDI devices", "");
    private static final MidiDeviceGroup midi_in_node = new MidiDeviceGroup("IN", "MIDI input devices (MIDI keyboard etc.)");
    private static final MidiDeviceGroup midi_out_node = new MidiDeviceGroup("OUT", "MIDI output devices (MIDI synthesizer etc.)");
    private static final MidiDeviceGroup midi_in_out_node = new MidiDeviceGroup("IN/OUT", "MIDI input/output devices (MIDI sequencer etc.)");
    private static final MidiDeviceGroup[] midi_in_path = new MidiDeviceGroup[]{root_node, midi_in_node};
    private static final MidiDeviceGroup[] midi_out_path = new MidiDeviceGroup[]{root_node, midi_out_node};
    private static final MidiDeviceGroup[] midi_in_out_path = new MidiDeviceGroup[]{root_node, midi_in_out_node};
    private EventListenerList listenerList = new EventListenerList();

    public MidiDeviceTreeModel(List<MidiConnecterListModel> list) {
        this.device_models = list;
    }

    @Override
    public Object getRoot() {
        return root_node;
    }

    @Override
    public Object getChild(Object object, int n) {
        if (object == root_node) {
            return n == 0 ? midi_out_node : (n == 1 ? midi_in_node : (n == 2 ? midi_in_out_node : null));
        }
        if (object == midi_in_node) {
            int n2 = 0;
            for (MidiConnecterListModel midiConnecterListModel : this.device_models) {
                if (!midiConnecterListModel.hasTx() || midiConnecterListModel.hasRx() || n2++ != n) continue;
                return midiConnecterListModel;
            }
            return null;
        }
        if (object == midi_out_node) {
            int n3 = 0;
            for (MidiConnecterListModel midiConnecterListModel : this.device_models) {
                if (!midiConnecterListModel.hasRx() || midiConnecterListModel.hasTx() || n3++ != n) continue;
                return midiConnecterListModel;
            }
            return null;
        }
        if (object == midi_in_out_node) {
            int n4 = 0;
            for (MidiConnecterListModel midiConnecterListModel : this.device_models) {
                if (!midiConnecterListModel.hasRx() || !midiConnecterListModel.hasTx() || n4++ != n) continue;
                return midiConnecterListModel;
            }
            return null;
        }
        return null;
    }

    @Override
    public int getChildCount(Object object) {
        if (object == root_node) {
            return 3;
        }
        if (object == midi_in_node) {
            int n = 0;
            for (MidiConnecterListModel midiConnecterListModel : this.device_models) {
                if (!midiConnecterListModel.hasTx() || midiConnecterListModel.hasRx()) continue;
                ++n;
            }
            return n;
        }
        if (object == midi_out_node) {
            int n = 0;
            for (MidiConnecterListModel midiConnecterListModel : this.device_models) {
                if (!midiConnecterListModel.hasRx() || midiConnecterListModel.hasTx()) continue;
                ++n;
            }
            return n;
        }
        if (object == midi_in_out_node) {
            int n = 0;
            for (MidiConnecterListModel midiConnecterListModel : this.device_models) {
                if (!midiConnecterListModel.hasRx() || !midiConnecterListModel.hasTx()) continue;
                ++n;
            }
            return n;
        }
        return 0;
    }

    @Override
    public int getIndexOfChild(Object object, Object object2) {
        if (object == root_node) {
            return object2 == midi_out_node ? 0 : (object2 == midi_in_node ? 1 : (object2 == midi_in_out_node ? 2 : -1));
        }
        if (object == midi_in_node) {
            int n = 0;
            for (MidiConnecterListModel midiConnecterListModel : this.device_models) {
                if (!midiConnecterListModel.hasTx() || midiConnecterListModel.hasRx()) continue;
                if (midiConnecterListModel == object2) {
                    return n;
                }
                ++n;
            }
            return -1;
        }
        if (object == midi_out_node) {
            int n = 0;
            for (MidiConnecterListModel midiConnecterListModel : this.device_models) {
                if (!midiConnecterListModel.hasRx() || midiConnecterListModel.hasTx()) continue;
                if (midiConnecterListModel == object2) {
                    return n;
                }
                ++n;
            }
            return -1;
        }
        if (object == midi_in_out_node) {
            int n = 0;
            for (MidiConnecterListModel midiConnecterListModel : this.device_models) {
                if (!midiConnecterListModel.hasRx() || !midiConnecterListModel.hasTx()) continue;
                if (midiConnecterListModel == object2) {
                    return n;
                }
                ++n;
            }
            return -1;
        }
        return -1;
    }

    @Override
    public boolean isLeaf(Object object) {
        return object instanceof MidiConnecterListModel;
    }

    @Override
    public void valueForPathChanged(TreePath treePath, Object object) {
    }

    @Override
    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.listenerList.add(TreeModelListener.class, treeModelListener);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.listenerList.remove(TreeModelListener.class, treeModelListener);
    }

    public void fireTreeNodesChanged(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        Object[] objectArray3 = this.listenerList.getListenerList();
        for (int i = objectArray3.length - 2; i >= 0; i -= 2) {
            if (objectArray3[i] != TreeModelListener.class) continue;
            ((TreeModelListener)objectArray3[i + 1]).treeNodesChanged(new TreeModelEvent(object, objectArray, nArray, objectArray2));
        }
    }

    public void fireDeviceStatusChanged(MidiConnecterListModel midiConnecterListModel) {
        this.fireTreeNodesChanged(this, midiConnecterListModel.hasRx() ? midi_out_path : midi_in_path, new int[]{this.getIndexOfChild(midiConnecterListModel.hasRx() ? midi_out_node : midi_in_node, midiConnecterListModel)}, new Object[]{midiConnecterListModel});
    }
}

