/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.AbstractButton;
import javax.swing.Icon;

class ButtonIcon
implements Icon {
    public static final int BLANK_ICON = 0;
    public static final int REC_ICON = 1;
    public static final int PLAY_ICON = 2;
    public static final int STOP_ICON = 3;
    public static final int EJECT_ICON = 4;
    public static final int PAUSE_ICON = 5;
    public static final int ANO_GAKKI_ICON = 6;
    public static final int INVERSION_ICON = 8;
    public static final int DARK_MODE_ICON = 9;
    public static final int X_ICON = 10;
    public static final int REPEAT_ICON = 11;
    public static final int MIDI_CONNECTOR_ICON = 12;
    public static final int NATURAL_ICON = 13;
    public static final int EDIT_ICON = 14;
    public static final int FORWARD_ICON = 15;
    public static final int BACKWARD_ICON = 16;
    public static final int TOP_ICON = 17;
    public static final int BOTTOM_ICON = 18;
    public static final int A128TH_NOTE_ICON = 128;
    public static final int DOTTED_128TH_NOTE_ICON = 129;
    public static final int A64TH_NOTE_ICON = 130;
    public static final int DOTTED_64TH_NOTE_ICON = 131;
    public static final int A32ND_NOTE_ICON = 132;
    public static final int DOTTED_32ND_NOTE_ICON = 133;
    public static final int A16TH_NOTE_ICON = 134;
    public static final int DOTTED_16TH_NOTE_ICON = 135;
    public static final int A8TH_NOTE_ICON = 136;
    public static final int DOTTED_8TH_NOTE_ICON = 137;
    public static final int QUARTER_NOTE_ICON = 138;
    public static final int DOTTED_QUARTER_NOTE_ICON = 139;
    public static final int HALF_NOTE_ICON = 140;
    public static final int DOTTED_HALF_NOTE_ICON = 141;
    public static final int WHOLE_NOTE_ICON = 142;
    private int icon_kind;
    private int width = 16;
    private int height = 16;
    private int margin = 3;
    private int note_head_width = 8;
    private int note_head_height = 6;
    private int eject_bottom_line_width = 2;
    private int[] xPoints;
    private int[] yPoints;

    public int getIconKind() {
        return this.icon_kind;
    }

    public boolean isMusicalNote() {
        return this.icon_kind >= 128 && this.icon_kind <= 142;
    }

    public boolean isDottedMusicalNote() {
        return this.isMusicalNote() && (this.icon_kind & 1) != 0;
    }

    public int getMusicalNoteValueIndex() {
        return this.isMusicalNote() ? (143 - this.icon_kind) / 2 : -1;
    }

    public ButtonIcon(int n) {
        this.icon_kind = n;
        switch (this.icon_kind) {
            case 2: {
                this.xPoints = new int[4];
                this.yPoints = new int[4];
                this.xPoints[0] = this.margin;
                this.yPoints[0] = this.margin;
                this.xPoints[1] = this.width - this.margin;
                this.yPoints[1] = this.height / 2;
                this.xPoints[2] = this.margin;
                this.yPoints[2] = this.height - this.margin;
                this.xPoints[3] = this.margin;
                this.yPoints[3] = this.margin;
                break;
            }
            case 4: {
                this.xPoints = new int[4];
                this.yPoints = new int[4];
                this.xPoints[0] = this.width / 2;
                this.yPoints[0] = this.margin;
                this.xPoints[1] = this.width - this.margin;
                this.yPoints[1] = this.height - this.margin - 2 * this.eject_bottom_line_width;
                this.xPoints[2] = this.margin;
                this.yPoints[2] = this.height - this.margin - 2 * this.eject_bottom_line_width;
                this.xPoints[3] = this.width / 2;
                this.yPoints[3] = this.margin;
                break;
            }
            case 16: 
            case 17: {
                this.xPoints = new int[8];
                this.yPoints = new int[8];
                this.xPoints[0] = this.width - this.margin;
                this.yPoints[0] = this.margin;
                this.xPoints[1] = this.width - this.margin;
                this.yPoints[1] = this.height - this.margin;
                this.xPoints[2] = this.width / 2;
                this.yPoints[2] = this.height / 2;
                this.xPoints[3] = this.width / 2;
                this.yPoints[3] = this.height - this.margin;
                this.xPoints[4] = this.margin;
                this.yPoints[4] = this.height / 2;
                this.xPoints[5] = this.width / 2;
                this.yPoints[5] = this.margin;
                this.xPoints[6] = this.width / 2;
                this.yPoints[6] = this.height / 2;
                this.xPoints[7] = this.width - this.margin;
                this.yPoints[7] = this.margin;
                break;
            }
            case 15: 
            case 18: {
                this.xPoints = new int[8];
                this.yPoints = new int[8];
                this.xPoints[0] = this.margin;
                this.yPoints[0] = this.margin;
                this.xPoints[1] = this.margin;
                this.yPoints[1] = this.height - this.margin;
                this.xPoints[2] = this.width / 2;
                this.yPoints[2] = this.height / 2;
                this.xPoints[3] = this.width / 2;
                this.yPoints[3] = this.height - this.margin;
                this.xPoints[4] = this.width - this.margin;
                this.yPoints[4] = this.height / 2;
                this.xPoints[5] = this.width / 2;
                this.yPoints[5] = this.margin;
                this.xPoints[6] = this.width / 2;
                this.yPoints[6] = this.height / 2;
                this.xPoints[7] = this.margin;
                this.yPoints[7] = this.margin;
                break;
            }
            case 6: 
            case 8: {
                this.width = 32;
                break;
            }
            case 11: {
                this.xPoints = new int[4];
                this.yPoints = new int[4];
                this.xPoints[0] = this.width / 2 - 2;
                this.yPoints[0] = this.margin;
                this.xPoints[1] = this.width / 2 + 2;
                this.yPoints[1] = this.margin - 4;
                this.xPoints[2] = this.width / 2 + 2;
                this.yPoints[2] = this.margin + 5;
                this.xPoints[3] = this.width / 2 - 2;
                this.yPoints[3] = this.margin + 1;
            }
        }
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        boolean bl = component instanceof AbstractButton && ((AbstractButton)component).isSelected() || component instanceof InversionAndOmissionLabel && ((InversionAndOmissionLabel)component).isAutoInversionMode();
        int n3 = component instanceof InversionAndOmissionLabel ? ((InversionAndOmissionLabel)component).getOmissionNoteIndex() : -1;
        graphics2D.setColor(component.isEnabled() ? component.getForeground() : component.getBackground().darker());
        graphics2D.translate(n, n2);
        switch (this.icon_kind) {
            case 1: {
                if (component.isEnabled()) {
                    graphics.setColor(Color.red);
                }
                graphics2D.fillOval(this.margin, this.margin, this.width - 2 * this.margin, this.height - 2 * this.margin);
                break;
            }
            case 17: {
                graphics2D.fillRect(this.margin == 0 ? 0 : this.margin - 1, this.margin, 2, this.height - 2 * this.margin);
            }
            case 2: 
            case 15: 
            case 16: {
                graphics2D.fillPolygon(this.xPoints, this.yPoints, this.xPoints.length);
                break;
            }
            case 18: {
                graphics2D.fillRect(this.width - 1 - this.margin, this.margin, 2, this.height - 2 * this.margin);
                graphics2D.fillPolygon(this.xPoints, this.yPoints, this.xPoints.length);
                break;
            }
            case 3: {
                graphics2D.fillRect(this.margin + 1, this.margin + 1, this.width - 2 * (this.margin + 1), this.height - 2 * (this.margin + 1));
                break;
            }
            case 5: {
                graphics2D.fillRect(this.margin + 1, this.margin + 1, this.width / 5, this.height - 2 * (this.margin + 1));
                graphics2D.fillRect(this.width - 1 - this.margin - this.width / 5, this.margin + 1, this.width / 5, this.height - 2 * (this.margin + 1));
                break;
            }
            case 4: {
                graphics2D.fillPolygon(this.xPoints, this.yPoints, this.xPoints.length);
                graphics2D.fillRect(this.margin + 1, this.height - this.margin - this.eject_bottom_line_width, this.width - 2 * this.margin - 1, this.eject_bottom_line_width);
                break;
            }
            case 6: {
                graphics2D.setBackground(component.getBackground());
                graphics2D.clearRect(0, 0, this.width, this.height);
                graphics2D.setColor(Color.cyan);
                graphics2D.drawRect(4, 4, 10, 10);
                graphics2D.drawLine(1, 14, 30, 4);
                graphics2D.drawOval(18, 1, 12, 12);
                if (bl) break;
                graphics2D.setColor(Color.red);
                graphics2D.drawLine(0, 0, this.width - 1, this.height - 1);
                graphics2D.drawLine(0, this.height - 1, this.width - 1, 0);
                break;
            }
            case 8: {
                graphics2D.setBackground(component.getBackground());
                graphics2D.clearRect(0, 0, this.width, this.height);
                graphics2D.setColor(component.getBackground().darker());
                graphics2D.drawRect(0, 0, this.width - 1, this.height - 1);
                graphics2D.drawLine(8, 0, 8, this.height);
                graphics2D.drawLine(16, 0, 16, this.height);
                graphics2D.drawLine(24, 0, 24, this.height);
                graphics2D.setColor(component.getForeground());
                graphics2D.fillRect(6, 0, 5, this.height / 2);
                graphics2D.fillRect(14, 0, 5, this.height / 2);
                graphics2D.fillRect(22, 0, 5, this.height / 2);
                if (bl) {
                    graphics2D.setColor(Music.Chord.index_colors[1]);
                    graphics2D.fillOval(2, 10, 4, 4);
                    if (n3 == 1) {
                        graphics2D.setColor(component.getForeground());
                        graphics2D.drawLine(1, 9, 7, 15);
                        graphics2D.drawLine(1, 15, 7, 9);
                    }
                    graphics2D.setColor(Music.Chord.index_colors[2]);
                    graphics2D.fillOval(10, 10, 4, 4);
                    if (n3 == 2) {
                        graphics2D.setColor(component.getForeground());
                        graphics2D.drawLine(9, 9, 15, 15);
                        graphics2D.drawLine(9, 15, 15, 9);
                    }
                    graphics2D.setColor(Music.Chord.index_colors[0]);
                    graphics2D.fillOval(26, 10, 4, 4);
                    if (n3 != 0) break;
                    graphics2D.setColor(component.getForeground());
                    graphics2D.drawLine(25, 9, 31, 15);
                    graphics2D.drawLine(25, 15, 31, 9);
                    break;
                }
                graphics2D.setColor(Music.Chord.index_colors[0]);
                graphics2D.fillOval(1, 9, 6, 6);
                if (n3 == 0) {
                    graphics2D.setColor(component.getForeground());
                    graphics2D.drawLine(1, 9, 7, 15);
                    graphics2D.drawLine(1, 15, 7, 9);
                }
                graphics2D.setColor(Music.Chord.index_colors[1]);
                graphics2D.fillOval(10, 10, 4, 4);
                if (n3 == 1) {
                    graphics2D.setColor(component.getForeground());
                    graphics2D.drawLine(9, 9, 15, 15);
                    graphics2D.drawLine(9, 15, 15, 9);
                }
                graphics2D.setColor(Music.Chord.index_colors[2]);
                graphics2D.fillOval(18, 10, 4, 4);
                if (n3 != 2) break;
                graphics2D.setColor(component.getForeground());
                graphics2D.drawLine(17, 9, 23, 15);
                graphics2D.drawLine(17, 15, 23, 9);
                break;
            }
            case 9: {
                if (bl) {
                    graphics2D.setColor(component.getForeground().darker());
                    graphics2D.fillRect(0, 0, this.width, this.height);
                    graphics2D.setColor(Color.gray);
                    graphics2D.fillRect(this.width - 2, 0, 2, this.height);
                    graphics2D.drawLine(0, 0, this.width - 1, 0);
                    graphics2D.setColor(Color.gray.darker());
                    graphics2D.drawLine(0, 0, 0, this.height - 1);
                    graphics2D.drawLine(0, this.height - 1, this.width - 1, this.height - 1);
                    graphics2D.setColor(Color.orange.brighter());
                    graphics2D.fillRect(this.width - 6, this.height / 2 - 3, 2, 6);
                    break;
                }
                graphics2D.setColor(component.getBackground().brighter());
                graphics2D.fillRect(0, 0, this.width, this.height);
                graphics2D.setColor(Color.gray.brighter());
                graphics2D.drawLine(0, 0, this.width - 1, 0);
                graphics2D.drawLine(this.width - 1, 0, this.width - 1, this.height - 1);
                graphics2D.setColor(Color.gray);
                graphics2D.fillRect(0, 0, 2, this.height);
                graphics2D.drawLine(0, this.height - 1, this.width - 1, this.height - 1);
                graphics2D.setColor(Color.gray.brighter());
                graphics2D.fillRect(this.width - 6, this.height / 2 - 4, 4, 7);
                graphics2D.setColor(component.getForeground());
                graphics2D.fillRect(this.width - 5, this.height / 2 - 3, 2, 5);
                break;
            }
            case 10: {
                graphics2D.drawLine(4, 5, this.width - 5, this.height - 4);
                graphics2D.drawLine(4, 4, this.width - 4, this.height - 4);
                graphics2D.drawLine(5, 4, this.width - 4, this.height - 5);
                graphics2D.drawLine(this.width - 5, 4, 4, this.height - 5);
                graphics2D.drawLine(this.width - 4, 4, 4, this.height - 4);
                graphics2D.drawLine(this.width - 4, 5, 5, this.height - 4);
                break;
            }
            case 11: {
                graphics2D.drawArc(this.margin, this.margin, this.width - 2 * this.margin, this.height - 2 * this.margin, 150, 300);
                graphics2D.fillPolygon(this.xPoints, this.yPoints, this.xPoints.length);
                break;
            }
            case 12: {
                graphics2D.drawOval(0, 0, this.width - 2, this.height - 2);
                graphics2D.fillRect(this.width / 2 - 2, this.height - 4, 3, 3);
                graphics2D.fillOval(this.width / 2 - 2, 2, 3, 3);
                graphics2D.fillOval(this.width / 2 - 5, 4, 2, 2);
                graphics2D.fillOval(this.width / 2 + 2, 4, 2, 2);
                graphics2D.fillOval(this.width / 2 - 6, 7, 2, 2);
                graphics2D.fillOval(this.width / 2 + 3, 7, 2, 2);
                break;
            }
            case 13: {
                graphics2D.drawLine(this.width / 2 - 2, 1, this.width / 2 - 2, this.height - 4);
                graphics2D.drawLine(this.width / 2 + 1, 3, this.width / 2 + 1, this.height - 2);
                graphics2D.drawLine(this.width / 2 - 2, 4, this.width / 2 + 1, 4);
                graphics2D.drawLine(this.width / 2 - 2, 5, this.width / 2 + 1, 5);
                graphics2D.drawLine(this.width / 2 - 2, this.height - 6, this.width / 2 + 1, this.height - 6);
                graphics2D.drawLine(this.width / 2 - 2, this.height - 5, this.width / 2 + 1, this.height - 5);
                break;
            }
            case 14: {
                graphics2D.drawRect(3, 1, 10, 14);
                graphics2D.drawLine(5, 3, 11, 3);
                graphics2D.drawLine(5, 5, 11, 5);
                graphics2D.drawLine(5, 7, 11, 7);
                graphics2D.drawLine(5, 9, 11, 9);
                graphics2D.drawLine(5, 11, 11, 11);
                if (component.isEnabled()) {
                    graphics2D.setColor(Color.red);
                }
                graphics2D.drawLine(this.width - 1, 2, this.width - 9, 10);
                graphics2D.drawLine(this.width - 1, 3, this.width - 9, 11);
                break;
            }
            case 140: 
            case 141: {
                this.drawMusicalNoteStem(graphics2D);
            }
            case 142: {
                this.drawMusicalNoteHead(graphics2D);
                if (!this.isDottedMusicalNote()) break;
                this.drawMusicalNoteDot(graphics2D);
                break;
            }
            case 128: {
                this.drawMusicalNoteFlag(graphics2D, 4);
            }
            case 130: 
            case 131: {
                this.drawMusicalNoteFlag(graphics2D, 3);
            }
            case 132: 
            case 133: {
                this.drawMusicalNoteFlag(graphics2D, 2);
            }
            case 134: 
            case 135: {
                this.drawMusicalNoteFlag(graphics2D, 1);
            }
            case 136: 
            case 137: {
                this.drawMusicalNoteFlag(graphics2D, 0);
            }
            case 138: 
            case 139: {
                this.fillMusicalNoteHead(graphics2D);
                this.drawMusicalNoteStem(graphics2D);
                if (!this.isDottedMusicalNote()) break;
                this.drawMusicalNoteDot(graphics2D);
            }
        }
        graphics.translate(-n, -n2);
    }

    private void drawMusicalNoteFlag(Graphics2D graphics2D, int n) {
        graphics2D.drawLine(this.width / 2 + this.note_head_width / 2 - 1, 1 + n * 2, this.width / 2 + this.note_head_width / 2 + 4, 6 + n * 2);
    }

    private void drawMusicalNoteDot(Graphics2D graphics2D) {
        graphics2D.fillRect(this.width / 2 + this.note_head_width / 2 + 2, this.height - this.note_head_height + 3, 2, 2);
    }

    private void drawMusicalNoteStem(Graphics2D graphics2D) {
        graphics2D.fillRect(this.width / 2 + this.note_head_width / 2 - 1, 1, 1, this.height - this.note_head_height / 2);
    }

    private void drawMusicalNoteHead(Graphics2D graphics2D) {
        graphics2D.drawOval(this.width / 2 - this.note_head_width / 2, this.height - this.note_head_height, this.note_head_width - 1, this.note_head_height - 1);
    }

    private void fillMusicalNoteHead(Graphics2D graphics2D) {
        graphics2D.fillOval(this.width / 2 - this.note_head_width / 2, this.height - this.note_head_height, this.note_head_width, this.note_head_height);
    }
}

