/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JPanel;

class BeatPadPanel
extends JPanel
implements ActionListener {
    PianoKeyboardListener piano_keyboard_listener;
    Music.AbstractNoteTrackSpec track_spec;
    JPanel percussion_selecters_panel;
    JComboBox[] percussion_selecters = new JComboBox[Music.DrumTrackSpec.default_percussions.length];
    BeatPad beat_pad;

    public BeatPadPanel(PianoKeyboardListener pianoKeyboardListener) {
        this.piano_keyboard_listener = pianoKeyboardListener;
        this.percussion_selecters_panel = new JPanel();
        this.percussion_selecters_panel.setLayout(new BoxLayout(this.percussion_selecters_panel, 1));
        for (int i = 0; i < this.percussion_selecters.length; ++i) {
            this.percussion_selecters[i] = new JComboBox();
            this.percussion_selecters_panel.add(this.percussion_selecters[i]);
            this.percussion_selecters[i].addActionListener(this);
        }
        this.add(this.percussion_selecters_panel);
        this.beat_pad = new BeatPad(pianoKeyboardListener);
        this.add(this.beat_pad);
        this.beat_pad.setPreferredSize(new Dimension(400, 200));
        this.setLayout(new BoxLayout(this, 0));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        for (int i = 0; i < this.percussion_selecters.length; ++i) {
            JComboBox jComboBox = this.percussion_selecters[i];
            if (object != jComboBox) continue;
            int n = ((Music.DrumTrackSpec.PercussionComboBoxModel)jComboBox.getModel()).getSelectedNoteNo();
            this.piano_keyboard_listener.pianoKeyPressed(n, null);
        }
    }

    public void setTrackSpec(Music.AbstractNoteTrackSpec abstractNoteTrackSpec) {
        this.track_spec = abstractNoteTrackSpec;
        this.beat_pad.setTrackSpec(abstractNoteTrackSpec);
        if (abstractNoteTrackSpec instanceof Music.DrumTrackSpec) {
            Music.DrumTrackSpec drumTrackSpec = (Music.DrumTrackSpec)abstractNoteTrackSpec;
            for (int i = 0; i < this.percussion_selecters.length; ++i) {
                this.percussion_selecters[i].setModel(drumTrackSpec.models[i]);
            }
            this.percussion_selecters_panel.setVisible(true);
        } else if (abstractNoteTrackSpec instanceof Music.MelodyTrackSpec) {
            this.percussion_selecters_panel.setVisible(false);
        }
    }
}

