/*
 * Decompiled with CFR 0.152.
 */
import javax.sound.midi.MidiChannel;

abstract class AbstractMidiChannelStatus
implements MidiChannel {
    protected int channel;
    protected int program = 0;
    protected int pitch_bend = 8192;
    protected int[] controller_values = new int[128];
    protected boolean is_rhythm_part = false;
    protected static final int DATA_NONE = 0;
    protected static final int DATA_FOR_RPN = 1;
    protected final int DATA_FOR_NRPN = 2;
    protected int data_for = 0;

    public AbstractMidiChannelStatus(int n) {
        this.channel = n;
        this.resetAllValues(true);
    }

    public int getChannel() {
        return this.channel;
    }

    public boolean isRhythmPart() {
        return this.is_rhythm_part;
    }

    public void setRhythmPart(boolean bl) {
        this.is_rhythm_part = bl;
    }

    public void resetRhythmPart() {
        this.is_rhythm_part = this.channel == 9;
    }

    public void resetAllValues() {
        this.resetAllValues(false);
    }

    public void resetAllValues(boolean bl) {
        for (int i = 0; i < this.controller_values.length; ++i) {
            this.controller_values[i] = 0;
        }
        if (bl) {
            this.resetRhythmPart();
        }
        this.resetAllControllers();
        this.controller_values[10] = 64;
    }

    public void fireRpnChanged() {
    }

    protected void changeRPNData(int n) {
        int n2 = this.controller_values[6];
        int n3 = this.controller_values[38];
        if (n != 0) {
            if ((n3 += n) >= 100) {
                n3 = 0;
                this.controller_values[38] = ++n2;
            } else if (n3 < 0) {
                n3 = 0;
                this.controller_values[38] = --n2;
            }
            this.controller_values[6] = n3;
        }
        this.fireRpnChanged();
    }

    @Override
    public void noteOff(int n) {
    }

    @Override
    public void noteOff(int n, int n2) {
    }

    @Override
    public void noteOn(int n, int n2) {
    }

    @Override
    public int getController(int n) {
        return this.controller_values[n];
    }

    @Override
    public void programChange(int n) {
        this.program = n;
    }

    @Override
    public void programChange(int n, int n2) {
        this.controlChange(0, n >> 7 & 0x7F);
        this.controlChange(32, n & 0x7F);
        this.programChange(n2);
    }

    @Override
    public int getProgram() {
        return this.program;
    }

    @Override
    public void setPitchBend(int n) {
        this.pitch_bend = n;
    }

    @Override
    public int getPitchBend() {
        return this.pitch_bend;
    }

    @Override
    public void setPolyPressure(int n, int n2) {
    }

    @Override
    public int getPolyPressure(int n) {
        return 64;
    }

    @Override
    public void setChannelPressure(int n) {
    }

    @Override
    public int getChannelPressure() {
        return 64;
    }

    @Override
    public void allSoundOff() {
    }

    @Override
    public void allNotesOff() {
    }

    @Override
    public void resetAllControllers() {
        int n;
        this.controller_values[0] = 0;
        for (n = 64; n <= 67; ++n) {
            this.controller_values[n] = 0;
        }
        this.pitch_bend = 8192;
        for (n = 98; n <= 101; ++n) {
            this.controller_values[n] = 127;
        }
    }

    @Override
    public boolean localControl(boolean bl) {
        this.controlChange(122, bl ? 127 : 0);
        return false;
    }

    @Override
    public void setOmni(boolean bl) {
        this.controlChange(bl ? 125 : 124, 0);
    }

    @Override
    public boolean getOmni() {
        return false;
    }

    @Override
    public void setMono(boolean bl) {
    }

    @Override
    public boolean getMono() {
        return false;
    }

    @Override
    public void setMute(boolean bl) {
    }

    @Override
    public boolean getMute() {
        return false;
    }

    @Override
    public void setSolo(boolean bl) {
    }

    @Override
    public boolean getSolo() {
        return false;
    }

    @Override
    public void controlChange(int n, int n2) {
        this.controller_values[n] = n2 &= 0x7F;
        switch (n) {
            case 120: {
                this.allSoundOff();
                break;
            }
            case 123: {
                this.allNotesOff();
                break;
            }
            case 121: {
                this.resetAllControllers();
                break;
            }
            case 6: 
            case 38: {
                this.changeRPNData(0);
                break;
            }
            case 96: {
                this.changeRPNData(1);
                break;
            }
            case 97: {
                this.changeRPNData(-1);
                break;
            }
            case 98: 
            case 99: {
                this.data_for = 2;
                break;
            }
            case 100: 
            case 101: {
                this.data_for = 1;
                this.fireRpnChanged();
            }
        }
    }
}

