
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.sound.midi.*;

/***************************************************************************
 *
 *	Sequencer GUI parts
 *
 ***************************************************************************/

class TimeIndicator extends JPanel {
  TimeLabel time_position_label, time_length_label;
  private SequencerTimeRangeModel model;
  public TimeIndicator() {
    time_position_label = new TimeLabel();
    time_position_label.setToolTipText("Time position - ݈ʒuiFbj");
    time_length_label = new TimeLabel(TimeLabel.TIME_LENGTH);
    time_length_label.setToolTipText("Time length - Ȃ̒iFbj");
    setLayout( new BoxLayout( this, BoxLayout.X_AXIS ) );
    add( time_position_label );
    add( time_length_label );
  }
  public TimeIndicator(SequencerTimeRangeModel model) {
    this();
    (this.model = model).addChangeListener(
      new ChangeListener() {
        public void stateChanged(ChangeEvent e) {
          SequencerTimeRangeModel model = TimeIndicator.this.model;
          time_length_label.setTimeInSecond(model.getMaximum()/1000);
          time_position_label.setTimeInSecond(model.getValue()/1000);
        }
      }
    );
  }
}
class TimeLabel extends JLabel {
  public static final int TIME_POSITION = 0;
  public static final int TIME_LENGTH = 1;
  private int format_type;
  private int value_in_sec;
  public TimeLabel() { this(TIME_POSITION); }
  public TimeLabel(int format_type) {
    super();
    this.format_type = format_type;
    value_in_sec = -1;
    if( format_type == TIME_POSITION ) {
      float large_point_size = getFont().getSize2D() + 4;
      setFont( getFont().deriveFont(large_point_size) );
      setForeground( new Color(0x80,0x00,0x00) );
      setText("00:00");
    }
    else setText("/00:00");
  }
  public void setTimeInMicrosecond(long us) {
    setTimeInSecond( (int)(us/1000000) );
  }
  public void setTimeInSecond(int sec) {
    if( value_in_sec == sec ) return;
    value_in_sec = sec;
    if( sec < 0 )
      setText(null);
    else if( format_type == TIME_LENGTH )
      setText( String.format("/%02d:%02d", sec/60, sec%60) );
    else
      setText( String.format("%02d:%02d", sec/60, sec%60) );
  }
}

class MeasureIndicator extends JPanel {
  SequencerTimeRangeModel model;
  MeasureLabel measure_position_label, measure_length_label;
  public MeasureIndicator() {
    measure_position_label = new MeasureLabel();
    measure_position_label.setToolTipText("Measure:beat position - ߖځF");
    measure_length_label = new MeasureLabel(MeasureLabel.MEASURE_LENGTH);
    measure_length_label.setToolTipText("Measure length - ߂̐");
    setLayout( new BoxLayout( this, BoxLayout.X_AXIS ) );
    add( measure_position_label );
    add( measure_length_label );
  }
  public MeasureIndicator(SequencerTimeRangeModel model) {
    this();
    (this.model = model).addChangeListener(
      new ChangeListener() {
        public void stateChanged(ChangeEvent e) {
          SequencerTimeRangeModel model = MeasureIndicator.this.model;
          Sequencer sequencer = model.device_manager.getSequencer();
          MidiSequenceModel seq_model =
            model.device_manager.time_range_model.getSequenceModel();
          SequenceIndex seq_index = (
            seq_model == null ? null : seq_model.getSequenceIndex()
          );
          if( ! sequencer.isRunning() || sequencer.isRecording() ) {
            measure_length_label.setMeasure(
              seq_index == null ? 0 : seq_index.tickToMeasure( sequencer.getTickLength() )
            );
          }
          if( seq_index == null ) {
            measure_position_label.setMeasure( 0, 0 );
          }
          else {
            int measure_position = seq_index.tickToMeasure(
              sequencer.getTickPosition()
            );
            measure_position_label.setMeasure(
              measure_position, seq_index.last_beat
            );
          }
        }
      }
    );
  }
}
class MeasureLabel extends JLabel {
  public static final int MEASURE_POSITION = 0;
  public static final int MEASURE_LENGTH = 1;
  private int format_type;
  private int value;
  private int beat;
  public MeasureLabel() {
    this(MEASURE_POSITION);
  }
  public MeasureLabel(int format_type) {
    super();
    this.format_type = format_type;
    value = -1;
    beat = 0;
    if( format_type == MEASURE_POSITION ) {
      float large_point_size = getFont().getSize2D() + 4;
      setFont( getFont().deriveFont(large_point_size) );
      setForeground( new Color(0x80,0x00,0x00) );
      setText( "0001:01" );
    }
    else {
      setText( "/0000" );
    }
  }
  public void setMeasure(int measure, int beat) {
    if( value == measure && this.beat == beat ) {
      return;
    }
    value = measure;
    this.beat = beat;
    if( value < 0 )
      setText( null );
    else if( format_type == MEASURE_LENGTH )
      setText( String.format("/%04d", value) );
    else
      setText( String.format("%04d:%02d", value+1, this.beat+1) );
  }
  public void setMeasure(int measure) {
    setMeasure(measure,0);
  }
}

// V[PT[̍ĐXs[h
//
class SpeedSliderModel extends DefaultBoundedRangeModel
  implements ChangeListener
{
  private Sequencer sequencer;
  public SpeedSliderModel( Sequencer sequencer ) {
    super( 0, 0, -7, 7 );
    this.sequencer = sequencer;
    addChangeListener(this);
  }
  // ChangeListener
  public void stateChanged(ChangeEvent e) {
    int val = getValue();
    sequencer.setTempoFactor((float)(
      val == 0 ? 1.0 : Math.pow( 2.0, ((double)val)/12.0 )
    ));
  }
}
class SpeedSlider extends JPanel implements ActionListener
{
  static String items[] = {
    "x 1.0",
    "x 1.5",
    "x 2",
    "x 4",
    "x 8",
    "x 16",
  };
  JSlider slider;
  JLabel title_label;
  JComboBox scale_combo_box;
  public SpeedSlider( SpeedSliderModel model ) {
    add( title_label = new JLabel("Speed:") );
    add( slider = new JSlider(model) );
    add( scale_combo_box = new JComboBox(items) );
    scale_combo_box.addActionListener(this);
    slider.setPaintTicks(true);
    slider.setMajorTickSpacing(12);
    slider.setMinorTickSpacing(1);
    slider.setVisible(false);
  }
  public void actionPerformed(ActionEvent e) {
    int index = scale_combo_box.getSelectedIndex();
    SpeedSliderModel model = (SpeedSliderModel)slider.getModel();
    if( index == 0 ) {
      model.setValue(0);
      slider.setVisible(false);
      title_label.setVisible(true);
    }
    else {
      int max_val = ( index == 1 ? 7 : (index-1)*12 );
      model.setMinimum(-max_val);
      model.setMaximum(max_val);
      slider.setMajorTickSpacing( index == 1 ? 7 : 12 );
      slider.setMinorTickSpacing( index > 3 ? 12 : 1 );
      slider.setVisible(true);
      title_label.setVisible(false);
    }
  }
}

// GUI  Sequencer 𒼌邽߂̎Ԕ͈̓f[^f
//
class SequencerTimeRangeModel implements BoundedRangeModel {
  static final int INTERVAL_MS = 20;
  MidiDeviceManager device_manager;
  private Sequencer sequencer;
  javax.swing.Timer	timer;
  private boolean value_is_adjusting = false;
  private EventListenerList listenerList = new EventListenerList();
  //
  // Actions
  //
  public StartStopAction start_stop_action = new StartStopAction();
  class StartStopAction extends AbstractAction {
    Icon play_icon = new ButtonIcon(ButtonIcon.PLAY_ICON);
    Icon pause_icon = new ButtonIcon(ButtonIcon.PAUSE_ICON);
    {
      putValue(
        SHORT_DESCRIPTION,
        "Start/Stop recording or playing - ^܂͍Đ̊Jn^~"
      );
      putValue( LARGE_ICON_KEY, play_icon );
      putValue( SELECTED_KEY, false );
    }
    public void actionPerformed(ActionEvent event) {
      if( timer.isRunning() ) stop(); else start();
    }
    public void setRunning(boolean is_running) {
      putValue( LARGE_ICON_KEY,
        is_running ? pause_icon : play_icon
      );
      putValue( SELECTED_KEY, is_running );
    }
  }
  public Action move_backward_action = new AbstractAction() {
    {
      putValue( SHORT_DESCRIPTION, "Move backward 1 measure - Pߖ߂" );
      putValue( LARGE_ICON_KEY, new ButtonIcon(ButtonIcon.BACKWARD_ICON) );
    }
    public void actionPerformed( ActionEvent event ) {
      moveMeasure(-1);
    }
  };
  public Action move_forward_action = new AbstractAction() {
    {
      putValue( SHORT_DESCRIPTION, "Move forward 1 measure - Pߐi" );
      putValue( LARGE_ICON_KEY, new ButtonIcon(ButtonIcon.FORWARD_ICON) );
    }
    public void actionPerformed( ActionEvent event ) {
      moveMeasure(1);
    }
  };
  public Action toggle_repeat_action = new AbstractAction() {
    {
      putValue( SHORT_DESCRIPTION, "Repeat - JԂĐ" );
      putValue( LARGE_ICON_KEY, new ButtonIcon(ButtonIcon.REPEAT_ICON) );
      putValue( SELECTED_KEY, false );
    }
    public void actionPerformed(ActionEvent event) { }
  };
  //
  // Constructor
  //
  public SequencerTimeRangeModel( MidiDeviceManager device_manager ) {
    this.device_manager = device_manager;
    this.sequencer = device_manager.getSequencer();
    timer = new javax.swing.Timer(
      INTERVAL_MS,
      new ActionListener() {
        public void actionPerformed(ActionEvent e) {
          if( ! value_is_adjusting ) fireStateChanged();
        }
      }
    );
    timer.setCoalesce(true);
    sequencer.addMetaEventListener(
      new MetaEventListener() {
        public void meta(MetaMessage msg) {
          if( msg.getType() != 0x2F /* End-Of-Track */)
            return;
          timer.stop();
          start_stop_action.setRunning(false);
          sequencer.setMicrosecondPosition(0);
          if(
            (Boolean)toggle_repeat_action.getValue( Action.SELECTED_KEY ) ||
            SequencerTimeRangeModel.this.device_manager.editor_dialog.loadNext(1)
          ) start();
          else fireStateChanged();
        }
      }
    );
  }
  // BoundedRangeModel interface
  //
  public int getExtent() { return 0; }
  public int getMaximum() { return (int)(getMicrosecondLength()/1000L); }
  public int getMinimum() { return 0; }
  public int getValue() { return (int)(getMicrosecondPosition()/1000L); }
  public boolean getValueIsAdjusting() { return value_is_adjusting; }
  public void setExtent(int new_extent) {}
  public void setMaximum(int new_maximum) {}
  public void setMinimum(int new_minimum) {}
  public void setRangeProperties(int value, int extent, int min, int max, boolean adjusting) {
    sequencer.setMicrosecondPosition( 1000L * (long)value );
    value_is_adjusting = adjusting;
    fireStateChanged();
  }
  public void setValue(int new_value) {
    sequencer.setMicrosecondPosition( 1000L * (long)new_value );
    fireStateChanged();
  }
  public void setValueIsAdjusting(boolean b) {
    value_is_adjusting = b;
  }
  public void addChangeListener(ChangeListener listener) {
    listenerList.add(ChangeListener.class, listener);
  }
  public void removeChangeListener(ChangeListener listener) {
    listenerList.remove(ChangeListener.class, listener);
  }
  // Methods
  //
  public void fireStateChanged() {
    Object[] listeners = listenerList.getListenerList();
    for (int i = listeners.length-2; i>=0; i-=2) {
      if (listeners[i]==ChangeListener.class) {
        ((ChangeListener)listeners[i+1]).stateChanged(new ChangeEvent(this));
      }
    }
  }
  long getMicrosecondLength() {
    //
    // Sequencer.getMicrosecondLength() returns NEGATIVE value
    //  when over 0x7FFFFFFF microseconds (== 35.7913941166666... minutes),
    //  should be corrected when negative
    //
    long us_len = sequencer.getMicrosecondLength();
    return us_len < 0 ? 0x100000000L + us_len : us_len ;
  }
  long getMicrosecondPosition() {
    long us_pos = sequencer.getMicrosecondPosition();
    return us_pos < 0 ? 0x100000000L + us_pos : us_pos ;
  }

  private MidiSequenceModel seq_model = null;
  public MidiSequenceModel getSequenceModel() { return seq_model; }
  public boolean setSequenceModel( MidiSequenceModel seq_model ) {
    //
    // javax.sound.midi:Sequencer.setSequence() ̃hLgɂ
    // ũ\bh́ASequencer ĂꍇłĂяoƂł܂B v
    // ƂLq́Anull Zbgꍇɂ͓Ă͂܂ȂB
    // AI stop() Ă΂邽߂ IllegalStateException sequencer not open oB
    // ̌ۂ邽߁A炩߃`FbNĂ setSequence() ĂяoĂB
    //
    if( seq_model != null || sequencer.isOpen() ) {
      try {
        // Set new MIDI data
        sequencer.setSequence(
          seq_model == null ? null : seq_model.getSequence()
        );
      } catch ( InvalidMidiDataException e ) {
        e.printStackTrace();
        return false;
      }
    }
    this.seq_model = seq_model;
    fireStateChanged();
    return true;
  }
  // ߈ʒȗΈړ
  public void moveMeasure( int measure_offset ) {
    if( measure_offset == 0 || seq_model == null ) return;
    SequenceIndex seq_index = seq_model.getSequenceIndex();
    long new_tick_pos =
      seq_index.measureToTick(
        measure_offset + seq_index.tickToMeasure(
          sequencer.getTickPosition()
        )
      );
    if( new_tick_pos < 0 ) new_tick_pos = 0;
    else {
      long tick_len = sequencer.getTickLength();
      if( new_tick_pos > tick_len ) new_tick_pos = tick_len - 1;
    }
    sequencer.setTickPosition( new_tick_pos );
    fireStateChanged();
  }

  // Jn^I
  public boolean isStartable() {
    return sequencer.isOpen() && sequencer.getSequence() != null ;
  }
  public void start() {
    if( ! isStartable() ) {
      start_stop_action.setRunning(false);
      return;
    }
    start_stop_action.setRunning(true);
    timer.start();
    if( device_manager.isRecordable() ) {
      device_manager.resetMicrosecondPosition();
      System.gc();
      sequencer.startRecording();
    }
    else {
      System.gc(); sequencer.start();
    }
    fireStateChanged();
  }
  public void stop() {
    if( sequencer.isOpen() ) sequencer.stop();
    timer.stop();
    start_stop_action.setRunning(false);
    fireStateChanged();
  }
}
