/*
 * Base64 dialog
 */
import java.util.*;
import java.util.regex.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/* Base64 Codec 1.3 API from http://jakarta.apache.org/commons/codec/ */
import org.apache.commons.codec.binary.*;

class Base64Dialog extends JDialog
  implements ActionListener
{
  Insets zero_insets = new Insets(0,0,0,0);
  MediaTextArea media_text = null;
  JButton add_base64_button, base64_encode_button, clear_button;
  JPanel base64_panel;
  MidiEditor midi_editor;
  private boolean is_base64_available;

  public Base64Dialog(MidiEditor midi_editor) {
    this.midi_editor = midi_editor;
    setTitle("Base64-encoded MIDI sequence - " + ChordHelperApplet.VersionInfo.NAME);

    // Check Base64 availability
    try {
      Base64.decodeBase64( "".getBytes() );
      is_base64_available = true;
    } catch( NoClassDefFoundError e ) {
      // e.printStackTrace();
      is_base64_available = false;
    }
    if( is_base64_available ) {
      media_text = new MediaTextArea(8,56);
      JScrollPane scrollable_media_text = new JScrollPane(media_text);
      add_base64_button = new JButton( "Base64 Decode & Add to PlayList", new ButtonIcon(ButtonIcon.EJECT_ICON) );
      add_base64_button.setMargin(zero_insets);
      add_base64_button.addActionListener(this);
      add_base64_button.setToolTipText("Base64fR[hāAvCXg֒ǉ");
      clear_button = new JButton( "Clear" );
      clear_button.setMargin(zero_insets);
      clear_button.addActionListener(this);

      base64_panel = new JPanel();
      base64_panel.setLayout( new BoxLayout( base64_panel, BoxLayout.PAGE_AXIS ) );
      JPanel base64_button_panel = new JPanel();
      base64_button_panel.setLayout( new BoxLayout( base64_button_panel, BoxLayout.LINE_AXIS ) );
      base64_button_panel.add( new JLabel("Base64-encoded MIDI sequence:") );
      base64_button_panel.add( Box.createRigidArea(new Dimension(10, 0)) );
      base64_button_panel.add( add_base64_button );
      base64_button_panel.add( clear_button );
      base64_panel.add( base64_button_panel );
      base64_panel.add( scrollable_media_text );
      add(base64_panel);
    }
    // setLocationRelativeTo(applet);
    setBounds( 300, 250, 660, 300 );
  }
  //
  // ActionListener for JButton
  //
  public void actionPerformed(ActionEvent event) {
    Object obj = event.getSource();
    if( obj == add_base64_button ) {
      int last_index = midi_editor.addSequenceFromMidiData( getMIDIData(), null );
      if( last_index < 0 ) {
        media_text.requestFocusInWindow();
        last_index = midi_editor.seq_list_model.getRowCount() - 1;
      }
      midi_editor.seq_selection_model.setSelectionInterval( last_index, last_index );
      setVisible(false);
    }
    else if( obj == clear_button ) {
      media_text.setText(null);
    }
  }
  // Methods
  //
  public boolean isBase64Available() {
    return is_base64_available;
  }
  public void setMIDIData( byte[] midi_data ) {
    media_text.setBinary(midi_data);
  }
  public void setMIDIData( byte[] midi_data, String filename ) {
    media_text.setBinary(midi_data, "audio/midi", filename);
    media_text.selectAll();
  }
  public void setBase64Data( String base64_data ) {
    media_text.setText(null);
    media_text.append(base64_data);
  }
  public byte[] getMIDIData() {
    return media_text.getBinary();
  }
  public String getBase64Data() {
    return media_text.getText();
  }
}

/***************************************************************************
 *
 *	Base64 media text area
 */
class MediaTextArea extends JTextArea {
  public MediaTextArea(int rows, int columns) {
    super(rows,columns);
  }
  public void setBinary(byte[] binary_data) {
    setBinary(binary_data, null, null);
  }
  public void setBinary(byte[] binary_data, String content_type, String filename) {
    if( binary_data != null && binary_data.length > 0 ) {
      String header = "";
      if( content_type != null && filename != null ) {
        header += "Content-Type: " + content_type + "; name=\"" + filename + "\"\n";
        header += "Content-Transfer-Encoding: base64\n";
        header += "\n";
      }
      setText(
        header + new String(Base64.encodeBase64Chunked(binary_data)) + "\n"
      );
    }
  }
  public byte[] getBinary() {
    String rx = "^.*:.*$" ;
    String s = Pattern.compile( rx, Pattern.MULTILINE ).matcher(getText()).replaceAll("");
    // System.out.println("regx = [" + rx + "], outtext:\n" + s);
    return Base64.decodeBase64( s.getBytes() );
  }
}
