/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessControlException;
import java.util.ArrayList;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequence;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;

class SequenceListModel
extends AbstractTableModel {
    public static final int COLUMN_SEQ_NUMBER = 0;
    public static final int COLUMN_MODIFIED = 1;
    public static final int COLUMN_DIVISION_TYPE = 2;
    public static final int COLUMN_RESOLUTION = 3;
    public static final int COLUMN_TRACKS = 4;
    public static final int COLUMN_SEQ_POSITION = 5;
    public static final int COLUMN_SEQ_LENGTH = 6;
    public static final int COLUMN_FILENAME = 7;
    public static final int COLUMN_SEQ_NAME = 8;
    static String[] column_titles = new String[]{"No.", "Modified", "DivType", "Resolution", "Tracks", "Position", "Length", "Filename", "Sequence name"};
    static int[] column_width_ratios = new int[]{2, 6, 6, 6, 6, 6, 6, 16, 40};
    private ArrayList<MidiSequenceModel> sequences = new ArrayList();
    MidiDeviceManager device_manager;
    int second_position = 0;

    public SequenceListModel(MidiDeviceManager midiDeviceManager) {
        this.device_manager = midiDeviceManager;
        this.device_manager.time_range_model.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                int n = SequenceListModel.this.device_manager.time_range_model.getValue() / 1000;
                if (SequenceListModel.this.second_position == n) {
                    return;
                }
                SequenceListModel.this.second_position = n;
                SequenceListModel.this.fireTableCellUpdated(SequenceListModel.this.getLoadedIndex(), 5);
            }
        });
    }

    @Override
    public int getRowCount() {
        return this.sequences.size();
    }

    @Override
    public int getColumnCount() {
        return column_titles.length;
    }

    @Override
    public String getColumnName(int n) {
        return column_titles[n];
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 1: {
                return Boolean.class;
            }
            case 0: 
            case 3: 
            case 4: {
                return Integer.class;
            }
        }
        return String.class;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        switch (n2) {
            case 0: {
                return n;
            }
            case 1: {
                return this.sequences.get(n).isModified();
            }
            case 2: {
                float f = this.sequences.get(n).getSequence().getDivisionType();
                if (f == 0.0f) {
                    return "PPQ";
                }
                if (f == 24.0f) {
                    return "SMPTE_24";
                }
                if (f == 25.0f) {
                    return "SMPTE_25";
                }
                if (f == 30.0f) {
                    return "SMPTE_30";
                }
                if (f == 29.97f) {
                    return "SMPTE_30DROP";
                }
                return "[Unknown]";
            }
            case 3: {
                return this.sequences.get(n).getSequence().getResolution();
            }
            case 4: {
                return this.sequences.get(n).getSequence().getTracks().length;
            }
            case 5: {
                Sequence sequence = this.device_manager.getSequencer().getSequence();
                if (sequence != null && sequence == this.sequences.get(n).getSequence()) {
                    return String.format("%02d:%02d", this.second_position / 60, this.second_position % 60);
                }
                return "";
            }
            case 6: {
                long l = this.sequences.get(n).getSequence().getMicrosecondLength();
                int n3 = (int)((l < 0L ? (l = l + 0x100000000L) : l) / 1000L / 1000L);
                return String.format("%02d:%02d", n3 / 60, n3 % 60);
            }
            case 7: {
                String string = this.sequences.get(n).getFilename();
                return string == null ? "" : string;
            }
            case 8: {
                String string = this.sequences.get(n).toString();
                return string == null ? "" : string;
            }
        }
        return "";
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 == 7 || n2 == 8;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        switch (n2) {
            case 7: {
                String string = (String)object;
                this.sequences.get(n).setFilename(string);
                this.fireTableCellUpdated(n, 7);
                break;
            }
            case 8: {
                if (!this.sequences.get(n).setName((String)object)) break;
                this.fireTableCellUpdated(n, 1);
            }
        }
    }

    public void sizeColumnWidthToFit(JTable jTable) {
        int n;
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        int n2 = tableColumnModel.getTotalColumnWidth();
        int n3 = 0;
        for (n = 0; n < column_width_ratios.length; ++n) {
            n3 += column_width_ratios[n];
        }
        for (n = 0; n < column_width_ratios.length; ++n) {
            tableColumnModel.getColumn(n).setPreferredWidth(n2 * column_width_ratios[n] / n3);
        }
    }

    public boolean isModified() {
        for (MidiSequenceModel midiSequenceModel : this.sequences) {
            if (!midiSequenceModel.isModified()) continue;
            return true;
        }
        return false;
    }

    public void setModified(ListSelectionModel listSelectionModel, boolean bl) {
        int n = listSelectionModel.getMinSelectionIndex();
        int n2 = listSelectionModel.getMaxSelectionIndex();
        for (int i = n; i <= n2; ++i) {
            if (!listSelectionModel.isSelectedIndex(i)) continue;
            this.sequences.get(i).setModified(bl);
            this.fireTableCellUpdated(i, 1);
        }
    }

    public MidiSequenceModel getSequenceModel(ListSelectionModel listSelectionModel) {
        if (listSelectionModel.isSelectionEmpty()) {
            return null;
        }
        int n = listSelectionModel.getMinSelectionIndex();
        if (n >= this.sequences.size()) {
            return null;
        }
        return this.sequences.get(n);
    }

    public void fireSequenceChanged(ListSelectionModel listSelectionModel) {
        if (listSelectionModel.isSelectionEmpty()) {
            return;
        }
        this.fireSequenceChanged(listSelectionModel.getMinSelectionIndex(), listSelectionModel.getMaxSelectionIndex());
    }

    public void fireSequenceChanged(MidiSequenceModel midiSequenceModel) {
        for (int i = 0; i < this.sequences.size(); ++i) {
            if (this.sequences.get(i) != midiSequenceModel) continue;
            this.fireSequenceChanged(i, i);
        }
    }

    public void fireSequenceChanged(int n, int n2) {
        for (int i = n; i <= n2; ++i) {
            MidiSequenceModel midiSequenceModel = this.sequences.get(i);
            midiSequenceModel.setModified(true);
            if (this.device_manager.getSequencer().getSequence() != midiSequenceModel.getSequence()) continue;
            this.device_manager.time_range_model.setSequenceModel(midiSequenceModel);
        }
        this.fireTableRowsUpdated(n, n2);
    }

    public int addSequence() {
        Sequence sequence = new Music.ChordProgression().toMidiSequence();
        return sequence == null ? -1 : this.addSequence(sequence, null);
    }

    public int addSequence(Sequence sequence) {
        return this.addSequence(sequence, "");
    }

    public int addSequence(Sequence sequence, String string) {
        MidiSequenceModel midiSequenceModel = new MidiSequenceModel(this);
        midiSequenceModel.setSequence(sequence);
        midiSequenceModel.setFilename(string);
        this.sequences.add(midiSequenceModel);
        int n = this.sequences.size() - 1;
        this.fireTableRowsInserted(n, n);
        return n;
    }

    public int addSequence(byte[] byArray, String string) throws InvalidMidiDataException {
        return byArray == null ? this.addSequence() : this.addSequence(new ByteArrayInputStream(byArray), string);
    }

    public int addSequence(File file) throws InvalidMidiDataException, FileNotFoundException {
        FileInputStream fileInputStream = new FileInputStream(file);
        int n = this.addSequence(fileInputStream, file.getName());
        try {
            fileInputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return n;
    }

    public int addSequence(InputStream inputStream, String string) throws InvalidMidiDataException {
        Sequence sequence;
        if (inputStream == null) {
            return this.addSequence();
        }
        try {
            sequence = MidiSystem.getSequence(inputStream);
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            throw invalidMidiDataException;
        }
        catch (EOFException eOFException) {
            return -1;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return -1;
        }
        return this.addSequence(sequence, string);
    }

    public int addSequence(String string) throws InvalidMidiDataException, AccessControlException {
        Sequence sequence;
        URL uRL = this.toURL(string);
        if (uRL == null) {
            return -1;
        }
        try {
            sequence = MidiSystem.getSequence(uRL);
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            throw invalidMidiDataException;
        }
        catch (EOFException eOFException) {
            return -1;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return -1;
        }
        catch (AccessControlException accessControlException) {
            throw accessControlException;
        }
        return this.addSequence(sequence, uRL.getFile().replaceFirst("^.*/", ""));
    }

    public void removeSequence(ListSelectionModel listSelectionModel) {
        if (listSelectionModel.isSelectionEmpty()) {
            return;
        }
        int n = listSelectionModel.getMinSelectionIndex();
        if (this.sequences.get(n) == this.device_manager.time_range_model.getSequenceModel()) {
            this.device_manager.time_range_model.setSequenceModel(null);
        }
        this.sequences.remove(n);
        this.fireTableRowsDeleted(n, n);
    }

    public void loadToSequencer(int n) {
        int n2 = this.getLoadedIndex();
        if (n2 == n) {
            return;
        }
        MidiSequenceModel midiSequenceModel = this.sequences.get(n);
        this.device_manager.time_range_model.setSequenceModel(midiSequenceModel);
        midiSequenceModel.fireTableDataChanged();
        this.fireTableCellUpdated(n2, 5);
        this.fireTableCellUpdated(n, 5);
    }

    public int getLoadedIndex() {
        MidiSequenceModel midiSequenceModel = this.device_manager.time_range_model.getSequenceModel();
        for (int i = 0; i < this.sequences.size(); ++i) {
            if (this.sequences.get(i) != midiSequenceModel) continue;
            return i;
        }
        return -1;
    }

    public boolean loadNext(int n) {
        int n2;
        int n3 = this.getLoadedIndex();
        int n4 = n2 = n3 < 0 ? 0 : n3 + n;
        if (n2 < 0 || n2 >= this.sequences.size()) {
            return false;
        }
        this.loadToSequencer(n2);
        return true;
    }

    public int getTotalSeconds() {
        int n = 0;
        for (MidiSequenceModel midiSequenceModel : this.sequences) {
            long l = midiSequenceModel.getSequence().getMicrosecondLength();
            n += (int)((l < 0L ? (l = l + 0x100000000L) : l) / 1000L / 1000L);
        }
        return n;
    }

    public String getTotalLength() {
        int n = this.getTotalSeconds();
        return String.format("MIDI file playlist - Total length = %02d:%02d", n / 60, n % 60);
    }

    public URL toURL(String string) {
        if (string == null || string == "") {
            return null;
        }
        URI uRI = null;
        URL uRL = null;
        try {
            uRI = new URI(string);
            uRL = uRI.toURL();
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        return uRL;
    }
}

