/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Track;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.ListSelectionModel;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;

class MidiSequenceModel
extends AbstractTableModel {
    public static final int COLUMN_TRACK_NUMBER = 0;
    public static final int COLUMN_EVENTS = 1;
    public static final int COLUMN_MUTE = 2;
    public static final int COLUMN_SOLO = 3;
    public static final int COLUMN_RECORD_CHANNEL = 4;
    public static final int COLUMN_CHANNEL = 5;
    public static final int COLUMN_TRACK_NAME = 6;
    public static final String[] column_titles = new String[]{"No.", "Events", "Mute", "Solo", "RecCh", "Ch", "Track name"};
    public static final int[] column_width_ratios = new int[]{30, 60, 40, 40, 60, 40, 200};
    private SequenceListModel seq_list_model;
    private Sequence seq;
    private SequenceIndex seq_index;
    private String filename = "";
    private boolean is_modified = false;
    private ArrayList<MidiTrackModel> track_models = new ArrayList();

    public MidiSequenceModel(SequenceListModel sequenceListModel) {
        this.seq_list_model = sequenceListModel;
    }

    @Override
    public int getRowCount() {
        return this.seq == null ? 0 : this.seq.getTracks().length;
    }

    @Override
    public int getColumnCount() {
        return column_titles.length;
    }

    @Override
    public String getColumnName(int n) {
        return column_titles[n];
    }

    public Class getColumnClass(int n) {
        switch (n) {
            case 0: 
            case 1: {
                return Integer.class;
            }
            case 2: 
            case 3: {
                return this.seq == this.getSequencer().getSequence() ? Boolean.class : String.class;
            }
            case 4: 
            case 5: 
            case 6: {
                return String.class;
            }
        }
        return super.getColumnClass(n);
    }

    @Override
    public Object getValueAt(int n, int n2) {
        switch (n2) {
            case 0: {
                return n;
            }
            case 1: {
                return this.seq.getTracks()[n].size();
            }
            case 2: {
                return this.seq == this.getSequencer().getSequence() ? Boolean.valueOf(this.getSequencer().getTrackMute(n)) : "";
            }
            case 3: {
                return this.seq == this.getSequencer().getSequence() ? Boolean.valueOf(this.getSequencer().getTrackSolo(n)) : "";
            }
            case 4: {
                return this.seq == this.getSequencer().getSequence() ? this.track_models.get(n).getRecordingChannel() : "";
            }
            case 5: {
                int n3 = this.track_models.get(n).getChannel();
                return n3 < 0 ? "" : Integer.valueOf(n3 + 1);
            }
            case 6: {
                return this.track_models.get(n).toString();
            }
        }
        return "";
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        switch (n2) {
            case 2: 
            case 3: 
            case 4: {
                return this.seq == this.getSequencer().getSequence();
            }
            case 5: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        switch (n2) {
            case 2: {
                this.getSequencer().setTrackMute(n, (Boolean)object);
                break;
            }
            case 3: {
                this.getSequencer().setTrackSolo(n, (Boolean)object);
                break;
            }
            case 4: {
                this.track_models.get(n).setRecordingChannel((String)object);
                break;
            }
            case 5: {
                Integer n3;
                try {
                    n3 = new Integer((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    Integer n4 = new Integer(-1);
                    break;
                }
                n3 = n3 - 1;
                if (n3 <= 0 || n3 > 16) break;
                MidiTrackModel midiTrackModel = this.track_models.get(n);
                int n5 = midiTrackModel.getChannel();
                if (n3 == n5) break;
                midiTrackModel.setChannel(n3);
                this.setModified(true);
                this.fireTableCellUpdated(n, 1);
                break;
            }
            case 6: {
                this.track_models.get(n).setString((String)object);
            }
        }
        this.fireTableCellUpdated(n, n2);
    }

    public void sizeColumnWidthToFit(TableColumnModel tableColumnModel) {
        int n;
        int n2 = tableColumnModel.getTotalColumnWidth();
        int n3 = 0;
        for (n = 0; n < column_width_ratios.length; ++n) {
            n3 += column_width_ratios[n];
        }
        for (n = 0; n < column_width_ratios.length; ++n) {
            tableColumnModel.getColumn(n).setPreferredWidth(n2 * column_width_ratios[n] / n3);
        }
    }

    public Sequence getSequence() {
        return this.seq;
    }

    public void setSequence(Sequence sequence) {
        this.getSequencer().recordDisable(null);
        this.seq = sequence;
        int n = this.track_models.size();
        if (n > 0) {
            this.track_models.clear();
            this.fireTableRowsDeleted(0, n - 1);
        }
        if (sequence == null) {
            this.seq_index = null;
        } else {
            Track[] trackArray;
            this.seq_index = new SequenceIndex(sequence);
            for (Track track : trackArray = sequence.getTracks()) {
                this.track_models.add(new MidiTrackModel(track, this));
            }
            this.fireTableRowsInserted(0, trackArray.length - 1);
        }
    }

    public SequenceIndex getSequenceIndex() {
        return this.seq_index;
    }

    public void setModified(boolean bl) {
        this.is_modified = bl;
    }

    public boolean isModified() {
        return this.is_modified;
    }

    public void setFilename(String string) {
        this.filename = string;
    }

    public String getFilename() {
        return this.filename;
    }

    public String toString() {
        return MIDISpec.getNameOf(this.seq);
    }

    public boolean setName(String string) {
        if (string.equals(this.toString())) {
            return false;
        }
        if (!MIDISpec.setNameOf(this.seq, string)) {
            return false;
        }
        this.setModified(true);
        this.fireTableDataChanged();
        return true;
    }

    public byte[] getMIDIdata() {
        if (this.seq == null || this.seq.getTracks().length == 0) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            MidiSystem.write(this.seq, 1, byteArrayOutputStream);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public void fireTimeSignatureChanged() {
        this.seq_index = new SequenceIndex(this.seq);
    }

    public void fireTrackChanged(Track track) {
        int n = this.getTrackRow(track);
        if (n < 0) {
            return;
        }
        this.fireTableRowsUpdated(n, n);
        this.fireSequenceChanged();
    }

    public void fireSequenceChanged() {
        this.seq_list_model.fireSequenceChanged(this);
    }

    public MidiTrackModel getTrackModel(int n) {
        Track[] trackArray = this.seq.getTracks();
        if (trackArray.length == 0) {
            return null;
        }
        Track track = trackArray[n];
        for (MidiTrackModel midiTrackModel : this.track_models) {
            if (midiTrackModel.getTrack() != track) continue;
            return midiTrackModel;
        }
        return null;
    }

    public int getTrackRow(Track track) {
        Track[] trackArray = this.seq.getTracks();
        for (int i = 0; i < trackArray.length; ++i) {
            if (trackArray[i] != track) continue;
            return i;
        }
        return -1;
    }

    public void createTrack() {
        Track track = this.seq.createTrack();
        this.track_models.add(new MidiTrackModel(track, this));
        int n = this.seq.getTracks().length - 1;
        this.fireTableRowsInserted(n, n);
    }

    public void deleteTracks(ListSelectionModel listSelectionModel) {
        if (listSelectionModel.isSelectionEmpty()) {
            return;
        }
        int n = listSelectionModel.getMinSelectionIndex();
        int n2 = listSelectionModel.getMaxSelectionIndex();
        Track[] trackArray = this.seq.getTracks();
        for (int i = n2; i >= n; --i) {
            if (!listSelectionModel.isSelectedIndex(i)) continue;
            this.seq.deleteTrack(trackArray[i]);
            this.track_models.remove(i);
        }
        this.fireTableRowsDeleted(n, n2);
    }

    public Sequencer getSequencer() {
        return this.seq_list_model.device_manager.getSequencer();
    }

    public boolean isRecordable() {
        if (this.seq != this.getSequencer().getSequence()) {
            return false;
        }
        int n = this.getRowCount();
        for (int i = 0; i < n; ++i) {
            String string = (String)this.getValueAt(i, 4);
            if (string.equals("OFF")) continue;
            return true;
        }
        return false;
    }

    class RecordChannelCellEditor
    extends DefaultCellEditor {
        public RecordChannelCellEditor() {
            super(new RecordChannelComboBox());
        }
    }

    class RecordChannelComboBox
    extends JComboBox {
        public RecordChannelComboBox() {
            this.addItem("OFF");
            for (int i = 1; i <= 16; ++i) {
                this.addItem(String.format("%d", i));
            }
            this.addItem("ALL");
        }
    }
}

