/*
 * Decompiled with CFR 0.152.
 */
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.ShortMessage;

class MidiChannelMessageSender
implements MidiChannel {
    private VirtualMidiDevice vmd;
    private int channel;

    public MidiChannelMessageSender(VirtualMidiDevice virtualMidiDevice, int n) {
        this.vmd = virtualMidiDevice;
        this.channel = n;
    }

    public void sendShortMessage(int n, int n2, int n3) {
        ShortMessage shortMessage = new ShortMessage();
        try {
            shortMessage.setMessage(n, this.channel, n2, n3);
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            invalidMidiDataException.printStackTrace();
            return;
        }
        this.vmd.sendMidiMessage(shortMessage);
    }

    @Override
    public void noteOff(int n) {
        this.noteOff(n, 64);
    }

    @Override
    public void noteOff(int n, int n2) {
        this.sendShortMessage(128, n, n2);
    }

    @Override
    public void noteOn(int n, int n2) {
        this.sendShortMessage(144, n, n2);
    }

    @Override
    public void setPolyPressure(int n, int n2) {
        this.sendShortMessage(160, n, n2);
    }

    @Override
    public int getPolyPressure(int n) {
        return 64;
    }

    @Override
    public void controlChange(int n, int n2) {
        this.sendShortMessage(176, n, n2);
    }

    @Override
    public int getController(int n) {
        return 64;
    }

    @Override
    public void programChange(int n) {
        this.sendShortMessage(192, n, 0);
    }

    @Override
    public void programChange(int n, int n2) {
        this.controlChange(0, n >> 7 & 0x7F);
        this.controlChange(32, n & 0x7F);
        this.programChange(n2);
    }

    @Override
    public int getProgram() {
        return 0;
    }

    @Override
    public void setChannelPressure(int n) {
        this.sendShortMessage(208, n, 0);
    }

    @Override
    public int getChannelPressure() {
        return 64;
    }

    @Override
    public void setPitchBend(int n) {
        this.sendShortMessage(224, n & 0x7F, n >> 7 & 0x7F);
    }

    @Override
    public int getPitchBend() {
        return 8192;
    }

    @Override
    public void allSoundOff() {
        this.controlChange(120, 0);
    }

    @Override
    public void resetAllControllers() {
        this.controlChange(121, 0);
    }

    @Override
    public boolean localControl(boolean bl) {
        this.controlChange(122, bl ? 127 : 0);
        return false;
    }

    @Override
    public void allNotesOff() {
        this.controlChange(123, 0);
    }

    @Override
    public void setOmni(boolean bl) {
        this.controlChange(bl ? 125 : 124, 0);
    }

    @Override
    public boolean getOmni() {
        return false;
    }

    @Override
    public void setMono(boolean bl) {
    }

    @Override
    public boolean getMono() {
        return false;
    }

    @Override
    public void setMute(boolean bl) {
    }

    @Override
    public boolean getMute() {
        return false;
    }

    @Override
    public void setSolo(boolean bl) {
    }

    @Override
    public boolean getSolo() {
        return false;
    }
}

