/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;

class ChordDisplay
extends JLabel {
    Music.Chord chord = null;
    PianoKeyboard keyboard = null;
    ChordMatrix chord_matrix = null;
    String default_string = null;
    int note_no = -1;
    private boolean is_dark = false;
    private boolean is_mouse_entered = false;

    public ChordDisplay(String string, ChordMatrix chordMatrix, PianoKeyboard pianoKeyboard) {
        super(string, 0);
        this.default_string = string;
        this.keyboard = pianoKeyboard;
        this.chord_matrix = chordMatrix;
        if (chordMatrix != null) {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    if (ChordDisplay.this.chord != null) {
                        if ((mouseEvent.getModifiersEx() & 0x1000) != 0) {
                            ChordDisplay.this.chord_matrix.setSelectedChord((Music.Chord)null);
                        } else if (ChordDisplay.this.keyboard == null) {
                            ChordDisplay.this.chord_matrix.setSelectedChord(ChordDisplay.this.chord);
                        } else {
                            ChordDisplay.this.chord_matrix.setSelectedChordCapo(ChordDisplay.this.chord);
                        }
                    } else if (ChordDisplay.this.note_no >= 0) {
                        ChordDisplay.this.keyboard.noteOn(ChordDisplay.this.note_no);
                    }
                }

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                    if (ChordDisplay.this.note_no >= 0) {
                        ChordDisplay.this.keyboard.noteOff(ChordDisplay.this.note_no);
                    }
                }

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    ChordDisplay.this.is_mouse_entered = true;
                    if (ChordDisplay.this.note_no >= 0 || ChordDisplay.this.chord != null) {
                        ChordDisplay.this.repaint();
                    }
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    ChordDisplay.this.is_mouse_entered = false;
                    if (ChordDisplay.this.note_no >= 0 || ChordDisplay.this.chord != null) {
                        ChordDisplay.this.repaint();
                    }
                }
            });
            this.addMouseWheelListener(this.chord_matrix);
        }
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        Dimension dimension = this.getSize();
        if (this.is_mouse_entered && (this.note_no >= 0 || this.chord != null)) {
            graphics.setColor(Color.gray);
            graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
        }
    }

    private void setChordText() {
        this.setText(this.chord.toHtmlString(this.is_dark ? "#FFCC33" : "maroon"));
    }

    void setNote(int n) {
        this.setNote(n, false);
    }

    void setNote(int n, boolean bl) {
        this.setToolTipText(null);
        this.chord = null;
        this.note_no = n;
        if (n < 0) {
            this.setText(this.default_string);
            return;
        }
        if (bl) {
            this.setText("MIDI note No." + n + " : " + MIDISpec.getPercussionName(n));
        } else {
            this.setText("Note: " + Music.noteNoToSymbol(n) + "  -  MIDI note No." + n + " : " + Math.round(Music.noteNoToFrequency(n)) + "Hz");
        }
    }

    void setChord(Music.Chord chord) {
        this.chord = chord;
        this.note_no = -1;
        if (chord == null) {
            this.setText(this.default_string);
            this.setToolTipText(null);
        } else {
            this.setChordText();
            this.setToolTipText("Chord: " + chord.toName());
        }
    }

    void setDarkMode(boolean bl) {
        this.is_dark = bl;
        if (this.chord != null) {
            this.setChordText();
        }
    }
}

