/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;

class BeatPad
extends JComponent
implements MouseListener,
ComponentListener {
    PianoKeyboardListener piano_keyboard_listener;
    private int on_note_no = -1;
    Music.AbstractNoteTrackSpec track_spec;
    public static final int MAX_BEATS = 16;
    public static final int MAX_NOTES = 8;
    Rectangle[][] beat_buttons;
    Rectangle[][] continuous_beat_buttons;

    public BeatPad(PianoKeyboardListener pianoKeyboardListener) {
        this.piano_keyboard_listener = pianoKeyboardListener;
        this.addMouseListener(this);
        this.addComponentListener(this);
    }

    @Override
    public void paint(Graphics graphics) {
        block10: {
            Graphics2D graphics2D;
            block9: {
                super.paint(graphics);
                graphics2D = (Graphics2D)graphics;
                if (!(this.track_spec instanceof Music.DrumTrackSpec)) break block9;
                Music.DrumTrackSpec drumTrackSpec = (Music.DrumTrackSpec)this.track_spec;
                for (int i = 0; i < drumTrackSpec.beat_patterns.length; ++i) {
                    int n = 0;
                    int n2 = 32768;
                    while (n < 16) {
                        Rectangle rectangle = this.beat_buttons[i][n];
                        if ((drumTrackSpec.beat_patterns[i] & n2) != 0) {
                            graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                        } else {
                            graphics2D.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                        }
                        ++n;
                        n2 >>>= 1;
                    }
                }
                break block10;
            }
            if (!(this.track_spec instanceof Music.MelodyTrackSpec)) break block10;
            Music.MelodyTrackSpec melodyTrackSpec = (Music.MelodyTrackSpec)this.track_spec;
            int n = 0;
            int n3 = 32768;
            while (n < 16) {
                Rectangle rectangle = this.beat_buttons[0][n];
                if ((melodyTrackSpec.beat_pattern & n3) != 0) {
                    graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                } else {
                    graphics2D.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
                rectangle = this.continuous_beat_buttons[0][n];
                if ((melodyTrackSpec.continuous_beat_pattern & n3) != 0) {
                    graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                } else {
                    graphics2D.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
                ++n;
                n3 >>>= 1;
            }
        }
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        this.sizeChanged();
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.catchEvent(mouseEvent);
        if (this.on_note_no >= 0) {
            this.piano_keyboard_listener.pianoKeyPressed(this.on_note_no, mouseEvent);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.on_note_no >= 0) {
            this.piano_keyboard_listener.pianoKeyReleased(this.on_note_no, mouseEvent);
        }
        this.on_note_no = -1;
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if ((mouseEvent.getModifiers() & 0x10) == 16) {
            this.catchEvent(mouseEvent);
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    private void sizeChanged() {
        Dimension dimension = this.getSize();
        int n = 1;
        if (this.track_spec instanceof Music.DrumTrackSpec) {
            Music.DrumTrackSpec drumTrackSpec = (Music.DrumTrackSpec)this.track_spec;
            n = drumTrackSpec.models.length;
        }
        this.beat_buttons = new Rectangle[n][];
        this.continuous_beat_buttons = new Rectangle[n][];
        for (int i = 0; i < this.beat_buttons.length; ++i) {
            this.beat_buttons[i] = new Rectangle[16];
            this.continuous_beat_buttons[i] = new Rectangle[16];
            for (int j = 0; j < 16; ++j) {
                int n2 = dimension.width * 3 / 64;
                int n3 = dimension.height / n - 1;
                this.beat_buttons[i][j] = new Rectangle(j * dimension.width / 16, i * n3, n2, n3);
                n2 = dimension.width / 48;
                this.continuous_beat_buttons[i][j] = new Rectangle((j + 1) * dimension.width / 16 - n2 + 1, i * n3 + n3 / 3, n2 - 1, n3 / 3);
            }
        }
    }

    private void catchEvent(MouseEvent mouseEvent) {
        block7: {
            Point point;
            block6: {
                point = mouseEvent.getPoint();
                if (!(this.track_spec instanceof Music.DrumTrackSpec)) break block6;
                Music.DrumTrackSpec drumTrackSpec = (Music.DrumTrackSpec)this.track_spec;
                for (int i = 0; i < drumTrackSpec.beat_patterns.length; ++i) {
                    int n = 0;
                    int n2 = 32768;
                    while (n < 16) {
                        if (this.beat_buttons[i][n].contains(point)) {
                            int n3 = i;
                            drumTrackSpec.beat_patterns[n3] = drumTrackSpec.beat_patterns[n3] ^ n2;
                            this.on_note_no = drumTrackSpec.models[i].getSelectedNoteNo();
                            this.repaint();
                            return;
                        }
                        ++n;
                        n2 >>>= 1;
                    }
                }
                break block7;
            }
            if (!(this.track_spec instanceof Music.MelodyTrackSpec)) break block7;
            Music.MelodyTrackSpec melodyTrackSpec = (Music.MelodyTrackSpec)this.track_spec;
            int n = 0;
            int n4 = 32768;
            while (n < 16) {
                if (this.beat_buttons[0][n].contains(point)) {
                    melodyTrackSpec.beat_pattern ^= n4;
                    this.repaint();
                    return;
                }
                if (this.continuous_beat_buttons[0][n].contains(point)) {
                    melodyTrackSpec.continuous_beat_pattern ^= n4;
                    this.repaint();
                    return;
                }
                ++n;
                n4 >>>= 1;
            }
        }
    }

    public void setTrackSpec(Music.AbstractNoteTrackSpec abstractNoteTrackSpec) {
        this.track_spec = abstractNoteTrackSpec;
        this.sizeChanged();
        this.repaint();
    }
}

