/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.commons.codec.binary.Base64;

class Base64Dialog
extends JDialog
implements ActionListener {
    Insets zero_insets = new Insets(0, 0, 0, 0);
    MediaTextArea media_text = null;
    JButton add_base64_button;
    JButton base64_encode_button;
    JButton clear_button;
    JPanel base64_panel;
    MidiEditor midi_editor;
    private boolean is_base64_available;

    public Base64Dialog(MidiEditor midiEditor) {
        this.midi_editor = midiEditor;
        this.setTitle("Base64-encoded MIDI sequence - MIDI Chord Helper");
        try {
            Base64.decodeBase64((byte[])"".getBytes());
            this.is_base64_available = true;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            this.is_base64_available = false;
        }
        if (this.is_base64_available) {
            this.media_text = new MediaTextArea(8, 56);
            JScrollPane jScrollPane = new JScrollPane(this.media_text);
            this.add_base64_button = new JButton("Base64 Decode & Add to PlayList", new ButtonIcon(4));
            this.add_base64_button.setMargin(this.zero_insets);
            this.add_base64_button.addActionListener(this);
            this.add_base64_button.setToolTipText("Base64\u30c7\u30b3\u30fc\u30c9\u3057\u3066\u3001\u30d7\u30ec\u30a4\u30ea\u30b9\u30c8\u3078\u8ffd\u52a0");
            this.clear_button = new JButton("Clear");
            this.clear_button.setMargin(this.zero_insets);
            this.clear_button.addActionListener(this);
            this.base64_panel = new JPanel();
            this.base64_panel.setLayout(new BoxLayout(this.base64_panel, 3));
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 2));
            jPanel.add(new JLabel("Base64-encoded MIDI sequence:"));
            jPanel.add(Box.createRigidArea(new Dimension(10, 0)));
            jPanel.add(this.add_base64_button);
            jPanel.add(this.clear_button);
            this.base64_panel.add(jPanel);
            this.base64_panel.add(jScrollPane);
            this.add(this.base64_panel);
        }
        this.setBounds(300, 250, 660, 300);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.add_base64_button) {
            int n = this.midi_editor.addSequenceFromMidiData(this.getMIDIData(), null);
            if (n < 0) {
                this.media_text.requestFocusInWindow();
                n = this.midi_editor.seq_list_model.getRowCount() - 1;
            }
            this.midi_editor.seq_selection_model.setSelectionInterval(n, n);
            this.setVisible(false);
        } else if (object == this.clear_button) {
            this.media_text.setText(null);
        }
    }

    public boolean isBase64Available() {
        return this.is_base64_available;
    }

    public void setMIDIData(byte[] byArray) {
        this.media_text.setBinary(byArray);
    }

    public void setMIDIData(byte[] byArray, String string) {
        this.media_text.setBinary(byArray, "audio/midi", string);
        this.media_text.selectAll();
    }

    public void setBase64Data(String string) {
        this.media_text.setText(null);
        this.media_text.append(string);
    }

    public byte[] getMIDIData() {
        return this.media_text.getBinary();
    }

    public String getBase64Data() {
        return this.media_text.getText();
    }
}

