/*
 * Copyright (c) 2011, Cloudera, Inc. All Rights Reserved.
 *
 * Cloudera, Inc. licenses this file to you under the Apache License,
 * Version 2.0 (the "License"). You may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * This software is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for
 * the specific language governing permissions and limitations under the
 * License.
 */
package com.cloudera.lib.wsrs;

import com.cloudera.lib.util.Check;

import java.text.MessageFormat;

public abstract class Param<T> {
  protected T value;

  public T parseParam(String name, String str) {
    Check.notNull(name, "name");
    try {
      return (str != null && str.trim().length() > 0) ? parse(str) : null;
    }
    catch (Exception ex) {
      throw new IllegalArgumentException(
        MessageFormat.format("Parameter [{0}], invalid value [{1}], value must be [{2}]",
                             name, str, getDomain()));
    }
  }

  public T value() {
    return value;
  }

  protected void setValue(T value) {
    this.value = value;
  }

  protected abstract String getDomain();

  protected abstract T parse(String str) throws Exception;

  public String toString() {
    return value.toString();
  }
}
