#
# Cookbook Name:: nexus-grid
# Attributes:: default
#
# Copyright 2017, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

# Not supported yet.
force_override['nexus-grid']['https_enabled'] = false
force_override['nexus-grid']['with_ssl_cert_cookbook'] = false
# If ['nexus-grid']['with_ssl_cert_cookbook'] is true,
# node['nexus-grid']['docker-compose']['config']
# are overridden by the following 'common_name' attributes.
force_override['nexus-grid']['ssl_cert']['ca_names'] = []
force_override['nexus-grid']['ssl_cert']['common_name'] = node['fqdn']

default['nexus-grid']['docker-compose']['app_dir'] = "#{node['docker-grid']['compose']['app_dir']}/nexus"
default['nexus-grid']['docker-compose']['data_dir'] = "#{node['nexus-grid']['docker-compose']['app_dir']}/data"

force_override['nexus-grid']['docker-compose']['config_format_version'] = '2'
version_2_config = {
  # Version 2 docker-compose format
  'version' => '2',
  'services' => {
    'nexus' => {
      'restart' => 'always',
      'image' => 'sonatype/nexus3',
      'ports' => [
        #'8081:8081',
        #'8443:8443',
      ],
      'volumes' => [
        # This volume will be set by the nexus-grid::docker-compose recipe automatically.
        #"#{node['nexus-grid']['docker-compose']['data_dir']}:/nexus-data",
      ],
      'environment' => {
        #JAVA_MAX_HEAP => '1200m',  # passed as -Xmx. Defaults to 1200m.
        #JAVA_MIN_HEAP => '1200m',  # passed as -Xms. Defaults to 1200m.
        #EXTRA_JAVA_OPTS => '',  # Additional options can be passed to the JVM via this variable.
      },
    },
  },
}

default['nexus-grid']['docker-compose']['config'] = version_2_config
