name 'hbase-pleiades-with-security'
description 'Pleiades HBase cluster node with security'

run_list(
  'role[node_commons]',
  'role[nameservice-client-grid]',
  'role[hbase]',
  'role[jce_policy]'
)

#env_run_lists "prod" => ["recipe[apache2]"], "staging" => ["recipe[apache2::staging]"], "_default" => []

grid_etc_root = '/grid/etc'
grid_vol_root = '/grid/vol'
cluster_name = 'pleiades'
realm = 'GRID.EXAMPLE.COM'
hbase_attributes = {
  'with_security' => true,
  # hbase-env.sh
  
  # hbase-site.xml
  'this.cluster.name' => cluster_name, 
  'this.domain' => 'grid.example.com',
  'this.realm' => realm,
  'this.keytab.dir' => "#{grid_etc_root}/keytabs/#{cluster_name}",
  'this.namenode.fqdn' => '${this.cluster.name}-nn.${this.domain}',
  'hbase.zookeeper.quorum' \
    => 'zk00.grid.example.com,zk01.grid.example.com,zk02.grid.example.com',
  'hbase.master.kerberos.principal' => 'hbase/_HOST@${this.realm}',
  'jaas_master_kerberos_principal' => "hbase/${this.fqdn}@#{realm}",
  'jaas_regionserver_kerberos_principal' => "hbase/${this.fqdn}@#{realm}"
}

default_attributes(
  'grid' => {
    'etc_root' => grid_etc_root,
    'vol_root' => grid_vol_root,
    'max_vol_nums' => '4'
  },
  'hbase' => hbase_attributes
)

#override_attributes "apache2" => { "max_children" => "50" }
