#
# Copyright 2017, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

name 'devops-suite-with-ssl-on-docker'
description 'DevOps Suite with SSL on Docker'

host_cn = nil
ca_name = nil
#ca_name = 'grid_ca'
import_ca = false
# chef-solo or chef-client local mode
if $0.split.include?('chef-solo') || ($0.split.include?('chef-client') && ARGV.include?('-z'))
  require 'ohai'
  node = Ohai::System.new
  node.all_plugins

  host_cn = node['fqdn'] if host_cn.nil?
end
host_cn = 'devops.io.example.com' if host_cn.nil?
aptly_cn = host_cn       # e.g. 'aptly.io.example.com'
concourse_cn = host_cn   # e.g. 'concourse.io.example.com'
concourse_port    = '8443'
docker_reg_cn = host_cn  # e.g. 'registry.docker.example.com'
docker_reg_port   = '5000'
docker_reg_data_vol = '/opt/docker-compose/app/registry/data'
gitlab_cn = host_cn      # e.g. 'gitlab.io.example.com'
gitlab_https_port =  '443'
nexus_cn = host_cn       # e.g. 'nexus.io.example.com'

# for debug
with_ssl = true

common_names = [
  host_cn,
  aptly_cn,
  concourse_cn,
  docker_reg_cn,
  gitlab_cn,
  nexus_cn,
].compact.uniq

run_list(
  'role[devops-suite-on-docker]',
  'recipe[docker-grid::registry]',
)

#env_run_lists()

#default_attributes()

override_attributes(
  'ssl_cert' => {
    'ca_names' => [
      ca_name,
    ],
    'common_names' => common_names,
  },
  'docker-grid' => {
    'engine' => {
      'skip_setup' => false,
    },
    'compose' => {
      'skip_setup' => false,
    },
    'registry' => {
      'with_ssl_cert_cookbook' => with_ssl,
      'ssl_cert' => {
        'common_name' => docker_reg_cn,
      },
      'docker-compose' => {
        'host_data_volume' => docker_reg_data_vol,
        'config' => {
          'registry' => {
            'ports' => [
              "#{docker_reg_port}:5000",
            ],
            'environment' => {
              #'REGISTRY_AUTH' =>                'htpasswd',
              #'REGISTRY_AUTH_HTPASSWD_PATH' =>  '/auth/.htpasswd',
              #'REGISTRY_AUTH_HTPASSWD_REALM' => 'Registry Realm',
              # proxy cache only.
              'REGISTRY_PROXY_REMOTEURL' => 'https://registry-1.docker.io',
            },
            #'volumes' => [
            #],
          },
        },
      },
    },
  },
  'apt_utils' => {
    'aptly' => {
      'with_ssl_cert_cookbook' => with_ssl,
      'ssl_cert' => {
        'common_name' => aptly_cn,
      },
      'docker-compose' => {
        'config' => {
          'services' => {
            'reverseproxy' => {
              #'ports' => [
              #],
            },
            'aptly' => {
            },
          },
        },
      },
    },
  },
  'concourse-ci' => {
    'with_ssl_cert_cookbook' => with_ssl,
    'ssl_cert' => {
      'ca_names' => [
        ca_name,
      ],
      'common_name' => concourse_cn,
    },
    'docker-compose' => {
      'import_ca' => import_ca,
      'config' => {
        # Version 1 docker-compose format
        'concourse-db' => {
        },
        'concourse-web' => {
          'ports' => [
            "#{concourse_port}:8443",
          ],
          'environment' => {
            'CONCOURSE_TLS_BIND_PORT' => '8443',
            'CONCOURSE_EXTERNAL_URL' => "https://#{concourse_cn}:#{concourse_port}",
          },
        },
        'concourse-worker' => {
          'environment' => {
          },
        },
      },
    },
  },
  'gitlab-grid' => {
    'with_ssl_cert_cookbook' => with_ssl,
    'ssl_cert' => {
      'ca_name' => ca_name,
      'common_name' => gitlab_cn,
    },
    'gitlab.rb' => {
      'external_url' => "https://#{gitlab_cn}:#{gitlab_https_port}",
      'gitlab_rails' => {
        # 'time_zone' => 'Asia/Tokyo',
      },
    },
    'docker-compose' => {
      'config' => {
        'services' => {
          'gitlab' => {
            'hostname' => gitlab_cn,
            'ports' => [
              "#{gitlab_https_port}:#{gitlab_https_port}",
            ],
          },
        },
      },
    },
    'runner-docker-compose' => {
      'import_ca' => import_ca,
    },
  },
  'nexus-grid' => {
    'with_ssl_cert_cookbook' => with_ssl,
    'ssl_cert' => {
      'common_name' => nexus_cn,
    },
    'docker-compose' => {
      'config' => {
        'services' => {
          'reverseproxy' => {
            #'ports' => [
            #],
          },
          'nexus' => {
          },
        },
      },
    },
  },
)
