samba-grid Cookbook
===================

This cookbook sets up a Samba server.

## Contents


## Requirements

### platforms
- Debian, Ubuntu

### packages
- none.

## Attributes

|Key|Type|Description, example|Default|
|:--|:--|:--|:--|
|`['samba-grid']['group']['sambashare']['gid']`|String|`sambashare` group gid.|`nil`|
|`['samba-grid']['group']['sambashare']['members']`|Array|`sambashare` group members|`[]`|
|`['samba-grid']['smb.conf']`|Hash|Samba configurations.|See `attributes/default.rb`|
|`['samba-grid']['smb.conf']['global']`|Hash|`[global]` section configurations in the `smb.conf`.|`{}`|
|`['samba-grid']['smb.conf']['homes']`|Hash|`[homes]` section configurations in the `smb.conf`.|`{}`|
|`['samba-grid']['smb.conf']['printers']`|Hash|`[printers]` section configurations in the `smb.conf`.|`{}`|
|`['samba-grid']['smb.conf']['printD']`|Hash|`[print$]` section configurations in the `smb.conf`.|`{}`|

## Usage

### Recipes

#### samba-grid::default

This recipe does nothing.

#### samba-grid::server

This recipe installs Samba server.

### Role Examples

- `roles/samba.rb`

```ruby
name 'samba'
description 'Samba server'

run_list(
  'recipe[samba-grid::server]',
)

override_attributes(
  'samba-grid' => {
    'group' => {
      'sambashare' => {
        'gid' => '200',
        'members' => [
          'alice',
          'bob',
        ],
      },
    },
    'smb.conf' => {
      'global' => {
        'workgroup' => 'WORKGROUP',
        'wide links' => 'yes',
        'follow symlinks' => 'yes',
        'unix extensions' => 'no',
        'dos charset' => 'CP932',
        'printing' => 'BSD',
        'hosts allow' => '127. 192.168.1.',
        'passdb backend' => 'ldapsam:ldap://ldap.example.com',
        'ldap suffix' => 'dc=example,dc=com',
        'ldap user suffix' => 'ou=Users',
        'ldap group suffix' => 'ou=Groups',
        'ldap machine suffix' => 'ou=Computers',
        'ldap admin dn' => 'cn=admin,dc=example,dc=com',
        'ldap passwd sync' => 'yes',
        'ldap ssl' => 'start_tls',
        'usershare allow guests' => 'no',
      },
      'homes' => {
        'read only' => 'no',
        'create mask' => '0600',
        'vfs objects' => 'recycle',
        'recycle:keeptree' => 'yes',
      },
      'share' => {
        'comment' => 'shared data',
        'path' => '/u00/samba/share',
        'username' => 'alice, bob',
        'valid users' => 'alice, bob',
        'write list' => 'alice, bob',
        'force group' => 'sambashare',
        'read only' => 'No',
        'create mask' => '0660',
        'directory mask' => '0770',
        #'vfs objects' => 'recycle',
        #'recycle:keeptree' => 'yes',
      },
    },
  },
)
```

License and Authors
-------------------
- Author:: whitestar at osdn.jp

```text
Copyright 2016, whitestar

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
```
