#
# Copyright 2013-2014, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

$LOAD_PATH.push("#{File.dirname(__FILE__)}/_lib")
#${chef-repo}/roles/_lib/grid.rb
require 'grid'
require 'rubygems'
require 'bracecomp'

cluster_name = 'praesepe'
cluster_sym = cluster_name.to_sym
datanode_prefix = 'dn1'
datanode_digit_nums = 4

name "#{cluster_name}-gm"
description "#{cluster_name.capitalize} ganglia gmetad node"

run_list(
  'role[node_commons]',
  #'role[nameservice-client-grid]',
  'role[ganglia-gmond]',
  'role[ganglia-gmetad]',
  'role[ganglia-web]'
)

#env_run_lists()

this_subcluster = Grid::CLUSTERS[cluster_sym][:gmetads]
mcast_addr = this_subcluster[:mcast_addr]
port = '8649'
polling_interval = '30'
# uni-cast
udp_send_channels4ucast = []
this_subcluster[:nodes].first(2).each {|host|
  udp_send_channels4ucast.push(
    {
      'mcast_join' => '',
      'host' => "#{host}.#{Grid::DOMAIN}",
      'port' => port,
      'ttl' => ''
    }
  )
}

# for non-DataNodes
data_sources = []
Grid::CLUSTERS[cluster_sym].select{|key| key != :datanodes}.each {|key, cluster|
  data_sources.push(
    {
      :name => cluster[:alias],
      :polling_interval => polling_interval,
      # head nodes: 2
      :address_list => cluster[:nodes].first(2).map{|host| "#{host}.#{Grid::DOMAIN}"}
    }
  )
}

# for DataNodes
head_node_nums = 2
digit_nums = datanode_digit_nums
padstr = '0'
dn_data_sources = []
(0...2).step(40) {|v|
#(0...80).step(40) {|v|
  first_head = v.to_s.rjust(digit_nums, padstr)
  last_head = (v + head_node_nums -1).to_s.rjust(digit_nums, padstr)
  dn_data_sources.push( 
    {
      :name => "DataNode#{first_head}",
      :polling_interval => polling_interval,
      # dn10000
      :address_list => "#{datanode_prefix}{#{first_head}..#{last_head}}.#{Grid::DOMAIN}".expand
    }
  )
}

default_attributes(
  'ganglia' => {
    'web' => {
=begin
      'Allow' => [
        "from .#{Grid::DOMAIN}",
        'from 192.168.0.0/16'],
      'AuthType' => 'Kerberos',
      'mod_auth_kerb' => {
        'KrbAuthRealms' => Grid::REALM,
        'Krb5Keytab' => '/etc/krb5.keytab'
      }
=end
    }
  },
)

nagios_nodes = []
if defined? Grid::CLUSTERS[cluster_sym][:nagioses][:nodes] then
  nagios_nodes = Grid::CLUSTERS[cluster_sym][:nagioses][:nodes].map{|host| "#{host}.#{Grid::DOMAIN}"}
end

override_attributes(
  'ganglia' => {
    # gmond
    'cluster' => {
      'name' => this_subcluster[:alias],
      'owner' => Grid::DOMAIN
    },
    'static' => {
=begin
      ## static multi-cast
      'udp_send_channels' => [
        {
          'mcast_join' => mcast_addr,
          'host' => '',
          'port' => port,
          'ttl' => '1'
        }
      ],
      'udp_recv_channels' => [
        {
          'mcast_join' => mcast_addr,
          'port' => port,
          'bind' => mcast_addr
        }
      ],
=end
      ## static uni-cast
      'udp_send_channels' => udp_send_channels4ucast,
      'udp_recv_channels' => [
        {
          'mcast_join' => '',
          'port' => port,
          'bind' => ''
        }
      ],
    },
    # gmetad
    'gridname' => cluster_name.capitalize,
    'trusted_hosts' => ['127.0.0.1'] + nagios_nodes,
    'data_sources' => data_sources + dn_data_sources
  }
)
