# Set Hadoop-specific environment variables here.


export JAVA_HOME=<%= node['java']['java_home'] %>
# The directory where pid files are stored. /tmp by default.
export HADOOP_PID_DIR=<%= node['hadoop']['HADOOP_PID_DIR'] %>
# Where log files are stored. $HADOOP_HOME/logs by default.
export HADOOP_LOG_DIR=<%= node['hadoop']['HADOOP_LOG_DIR'] %> 

<% if node['hadoop']['with_security'] then -%>
export HADOOP_SECURE_DN_USER=<%= node['hadoop']['HADOOP_SECURE_DN_USER'] %>
export HADOOP_SECURE_DN_PID_DIR=<%= node['hadoop']['HADOOP_SECURE_DN_PID_DIR'] %>
export HADOOP_SECURE_DN_LOG_DIR=<%= node['hadoop']['HADOOP_SECURE_DN_LOG_DIR'] %>
<% end -%>

# Extra Java CLASSPATH elements.  Optional.
if [ x"$HADOOP_CLASSPATH" = x ]; then
    export HADOOP_CLASSPATH="<%= node['hadoop']['HADOOP_CLASSPATH'] %>"
else
    # for Hive and HCatalog
    export HADOOP_CLASSPATH="${HADOOP_CLASSPATH}:<%= node['hadoop']['HADOOP_CLASSPATH'] %>"
fi
export HADOOP_USER_CLASSPATH_FIRST=<%= node['hadoop']['HADOOP_USER_CLASSPATH_FIRST'] %>

<% if node['hadoop']['this.cluster.name'] != 'localhost' \
   && node['hadoop']['with_security'] then -%>
FQDN=`hostname --fqdn`
CLUSTER_NAME=<%= node['hadoop']['this.cluster.name'] %>
DOMAIN=<%= node['hadoop']['this.domain'] %>
export HADOOP_NAMENODE_OPTS="-Dthis.fqdn=${CLUSTER_NAME}-nn.${DOMAIN} ${HADOOP_NAMENODE_OPTS}"
export HADOOP_SECONDARYNAMENODE_OPTS="-Dthis.fqdn=${CLUSTER_NAME}-cn.${DOMAIN} ${HADOOP_SECONDARYNAMENODE_OPTS}"
export HADOOP_DATANODE_OPTS="-Dthis.fqdn=${FQDN} ${HADOOP_DATANODE_OPTS}"
export HADOOP_JOBTRACKER_OPTS="-Dthis.fqdn=${CLUSTER_NAME}-jt.${DOMAIN} ${HADOOP_JOBTRACKER_OPTS}"
export HADOOP_TASKTRACKER_OPTS="-Dthis.fqdn=${FQDN} ${HADOOP_TASKTRACKER_OPTS}"
<% end -%>

# for KSSL (of Hadoop 1.0 on the JDK 6)
KRB5_WEAK_CONF="-Djava.security.krb5.conf=${HADOOP_PREFIX}/conf/krb5-weak.conf"
KRB5_STRONG_CONF="-Djava.security.krb5.conf=${HADOOP_PREFIX}/conf/krb5-strong.conf"
export HADOOP_NAMENODE_OPTS="$KRB5_WEAK_CONF $HADOOP_NAMENODE_OPTS"
export HADOOP_SECONDARYNAMENODE_OPTS="$KRB5_WEAK_CONF $HADOOP_SECONDARYNAMENODE_OPTS"
export HADOOP_DATANODE_OPTS="$KRB5_STRONG_CONF $HADOOP_DATANODE_OPTS"
export HADOOP_BALANCER_OPTS="$KRB5_STRONG_CONF $HADOOP_BALANCER_OPTS"
export HADOOP_JOBTRACKER_OPTS="$KRB5_STRONG_CONF $HADOOP_JOBTRACKER_OPTS"
export HADOOP_TASKTRACKER_OPTS="$KRB5_STRONG_CONF $HADOOP_TASKTRACKER_OPTS"
# for fsck command only
#export HADOOP_CLIENT_OPTS="$KRB5_WEAK_CONF $HADOOP_CLIENT_OPTS"
# for standard hadoop sub-commands
export HADOOP_CLIENT_OPTS="$KRB5_STRONG_CONF $HADOOP_CLIENT_OPTS"


# The only required environment variable is JAVA_HOME.  All others are
# optional.  When running a distributed configuration it is best to
# set JAVA_HOME in this file, so that it is correctly defined on
# remote nodes.

# The java implementation to use.  Required.
# export JAVA_HOME=/usr/lib/j2sdk1.5-sun

# Extra Java CLASSPATH elements.  Optional.
# export HADOOP_CLASSPATH=

# The maximum amount of heap to use, in MB. Default is 1000.
# export HADOOP_HEAPSIZE=2000

# Extra Java runtime options.  Empty by default.
# export HADOOP_OPTS=-server

# Command specific options appended to HADOOP_OPTS when specified
export HADOOP_NAMENODE_OPTS="-Dcom.sun.management.jmxremote $HADOOP_NAMENODE_OPTS"
export HADOOP_SECONDARYNAMENODE_OPTS="-Dcom.sun.management.jmxremote $HADOOP_SECONDARYNAMENODE_OPTS"
export HADOOP_DATANODE_OPTS="-Dcom.sun.management.jmxremote $HADOOP_DATANODE_OPTS"
export HADOOP_BALANCER_OPTS="-Dcom.sun.management.jmxremote $HADOOP_BALANCER_OPTS"
export HADOOP_JOBTRACKER_OPTS="-Dcom.sun.management.jmxremote $HADOOP_JOBTRACKER_OPTS"
# export HADOOP_TASKTRACKER_OPTS=
# The following applies to multiple commands (fs, dfs, fsck, distcp etc)
# export HADOOP_CLIENT_OPTS

# Extra ssh options.  Empty by default.
# export HADOOP_SSH_OPTS="-o ConnectTimeout=1 -o SendEnv=HADOOP_CONF_DIR"

# Where log files are stored.  $HADOOP_HOME/logs by default.
# export HADOOP_LOG_DIR=${HADOOP_HOME}/logs

# File naming remote slave hosts.  $HADOOP_HOME/conf/slaves by default.
# export HADOOP_SLAVES=${HADOOP_HOME}/conf/slaves

# host:path where hadoop code should be rsync'd from.  Unset by default.
# export HADOOP_MASTER=master:/home/$USER/src/hadoop

# Seconds to sleep between slave commands.  Unset by default.  This
# can be useful in large clusters, where, e.g., slave rsyncs can
# otherwise arrive faster than the master can service them.
# export HADOOP_SLAVE_SLEEP=0.1

# The directory where pid files are stored. /tmp by default.
# export HADOOP_PID_DIR=/var/hadoop/pids

# A string representing this instance of hadoop. $USER by default.
# export HADOOP_IDENT_STRING=$USER

# The scheduling priority for daemon processes.  See 'man nice'.
# export HADOOP_NICENESS=10


<%
this_file = 'hadoop-env.sh'
if defined? node['hadoop']['extra_configs'][this_file] \
  && node['hadoop']['extra_configs'][this_file] != nil then
  node['hadoop']['extra_configs'][this_file].each do |key, value|
-%>
export <%= key %>=<%= value %>
<%
  end
end
-%>

