#
# Cookbook Name:: dsh
# Recipe:: default
#
# Copyright 2013, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

case node[:platform_family]
when 'debian'
  pkg = 'dsh'
  resources(:package => pkg) rescue package pkg do
    action :install
  end
when 'rhel'
  file_cache_path = Chef::Config[:file_cache_path]
  kernel_machine = (node[:kernel][:machine] == 'i686') \
    ? 'i386' \
    : node[:kernel][:machine]

  node['dsh']['rpm']['package_names'].each {|rpm_name|
    rpm_pkg = "#{rpm_name}.#{kernel_machine}.rpm"
    cookbook_file "#{file_cache_path}/#{rpm_pkg}" do
      source "#{node['dsh']['rpm']['cookbook_file_dir']}/#{rpm_pkg}"
      owner 'root'
      group 'root'
      mode '0644'
    end

    rpm_package rpm_name do
      source "#{file_cache_path}/#{rpm_pkg}"
      options '-vh --nodeps'
      not_if "rpm -qi #{rpm_pkg.split('-').first}"
      action :install
    end
  }
end

