name 'docker-registry'
description 'Docker Registry'

run_list(
  'recipe[ssl_cert::ca_certs]',
  'recipe[ssl_cert::server_key_pairs]',
  'role[docker]',
  'recipe[docker-grid::registry]',
)

#env_run_lists()

#default_attributes()

override_attributes(
  'docker-grid' => {
    'registry' => {
      'with_ssl_cert_cookbook' => true,
      'ssl_cert' => {
        'common_name' => 'registry.docker.example.com',
      },
      'docker-compose' => {
        'config' => {
          'registry' => {
            'restart' => 'always',
            'image' => 'registry:2',
            'ports' => [
              '5000:5000',
            ],
            'environment' => {
              #'REGISTRY_HTTP_TLS_CERTIFICATE' => '/certs/domain.crt',
              #'REGISTRY_HTTP_TLS_KEY' =>         '/certs/domain.key',
              'REGISTRY_AUTH' =>                'htpasswd',
              'REGISTRY_AUTH_HTPASSWD_PATH' =>  '/auth/.htpasswd',
              'REGISTRY_AUTH_HTPASSWD_REALM' => 'Registry Realm',
            },
            'volumes' => [
              '/var/lib/docker-registry:/var/lib/registry',
              #'/etc/ssl/certs/01registry_docker_example_com.crt:/certs/domain.crt:ro',
              #'/etc/ssl/private/01registry_docker_example_com.key:/certs/domain.key:ro',
              './auth:/auth',
            ],
          },
        },
      },
    },
  },
  'ssl_cert' => {
    'ca_names' => [
      'grid_ca',
    ],
    'common_names' => [
      'registry.docker.example.com',
    ],
  }
)

