#
# Cookbook Name:: drillbook
# Attributes:: default
#
# Copyright 2017, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

# Attribute Tests
default['drillbook']['type'] = {
  'Fixnum'    => 1,
  'String'    => 'String',
  'Symbol'    => :Symbol,
  'TrueClass' => true,
  'Array'     => ['Array'],
  'Hash'      => { 'key' => 'value' },
}

[
  [1,  default],
  [5,  force_default],
  [7,  normal],
  [9,  override],
  [13, force_override],
].each {|pos, method|
  (pos..14).each {|num|
    method['drillbook']["case#{num}"] = pos
    method['drillbook']["case-array#{num}"] = [pos]
    method['drillbook']["case-empty#{num}"] = ['initial'] if pos == 1
  }
}
