#
# Cookbook Name:: hadoop
# Recipe:: lzo-build
#
# Copyright 2013, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

# 
# Hadoop-LZO
#
# Origin:
#   http://code.google.com/p/hadoop-gpl-compression
#
# Forks:
#   https://github.com/twitter/hadoop-lzo
#     http://maven.twttr.com/com/hadoop/gplcompression/hadoop-lzo/
#   https://github.com/toddlipcon/hadoop-lzo
#   https://github.com/hortonworks/hadoop-lzo/tree/master
#

::Chef::Recipe.send(:include, Hadoop::Helper)

packages = nil

deb_packages = [
  'ant',
  'git',
  'build-essential',
  'autoconf',
  'libtool',
  'liblzo2-dev'
]

rpm_packages = [
  'ant',
  'ant-nodeps',  # for javah task to build toddlipcon/hadoop-lzo
  'git',
  'gcc-c++',
  'make',
  'autoconf',
  'automake',
  'libtool',
  'lzo-devel',
]

case node[:platform_family]
when 'debian'
  packages = deb_packages
when 'rhel'
  packages = rpm_packages
end

version, major_version, middle_version \
  = parse_version_number(node['hadoop']['version'])

packages.each {|pkg|
  resources(:package => pkg) rescue package pkg do
    action :install
  end
}

log <<-EOM
Please Check:
Extra requirements must be installed by the other recipes or roles.:
    Oracle JDK6
    Apache Maven 3.x
EOM

