#
# Cookbook Name:: krb5
# Recipe:: kdc
#
# Copyright 2013, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

case node[:platform_family]
  when 'debian'
    package 'krb5-kdc' do
      action :install
    end

    service 'krb5-kdc' do
      action [:enable, :start]
      supports :status => true, :restart => true, :reload => false
    end

    template '/etc/krb5kdc/kdc.conf' do
      source 'etc/krb5kdc/kdc.conf'
      owner 'root'
      group 'root'
      mode '0644'
    end
    template '/etc/krb5kdc/kpropd.acl' do
      source 'etc/krb5kdc/kpropd.acl'
      owner 'root'
      group 'root'
      mode '0644'
    end

    package 'xinetd' do
      action :install
    end

    service 'xinetd' do
      action [:enable, :start]
      supports :status => true, :restart => true, :reload => false
    end

    template '/etc/xinetd.d/krb_prop' do
      source 'etc/xinetd.d/krb_prop'
      owner 'root'
      group 'root'
      mode '0644'
      notifies :reload, 'service[xinetd]'
    end
  when 'rhel'
    package 'krb5-server' do
      action :install
    end

    service 'krb5kdc' do
      action [:enable, :start]
      supports :status => true, :restart => true, :reload => false
    end

    template '/var/kerberos/krb5kdc/kdc.conf' do
      source 'var/kerberos/krb5kdc/kdc.conf'
      owner 'root'
      group 'root'
      mode '0600'
    end
    template '/var/kerberos/krb5kdc/kpropd.acl' do
      source 'var/kerberos/krb5kdc/kpropd.acl'
      owner 'root'
      group 'root'
      mode '0600'
    end

    service 'kprop' do
      action [:enable, :start]
      supports :status => true, :restart => true, :reload => true
    end
end

log <<-EOM
Note:
You must add the host principal of this host for propagation.:
  $ sudo kadmin -p admin
  ...
  kadmin:  add_principal -randkey host/ns01.grid.example.com
  ...
  kadmin:  ktadd host/ns01.grid.example.com
  ...
EOM

