#
# Cookbook Name:: supermarket-omnibus-ya
# Attributes:: default
#
# Copyright 2017, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

=begin
default['supermarket_omnibus']['chef_server_url'] = 'https://chef.io.example.com'
default['supermarket_omnibus']['chef_oauth2_url'] = 'https://chef.io.example.com'
# Not recommended: instead use the `['supermarket_omnibus']['chef_oauth2_app_id_vault_item']` attribute.
#default['supermarket_omnibus']['chef_oauth2_app_id'] = '<supermarket_uid>'
# Not recommended: instead use the `['supermarket_omnibus']['chef_oauth2_secret_vault_item']` attribute.
#default['supermarket_omnibus']['chef_oauth2_secret'] = '<supermarket_secret>'
default['supermarket_omnibus']['chef_oauth2_verify_ssl'] = false
=end

# added attributes
default['supermarket_omnibus']['with_ssl_cert_cookbook'] = false
default['supermarket_omnibus']['ssl_cert']['common_name'] = node['fqdn']
default['supermarket_omnibus']['chef_oauth2_app_id_vault_item'] = {
=begin
  'vault' => 'supermarket',
  'name' => 'chef_oauth2_app_id',
  # single app_id or nested hash app_id path delimited by slash
  'env_context' => false,
  'key' => 'app_id',  # real hash path: "/app_id", Note: do not use `id`, which is preserved by Chef Vault.
  # or nested hash id path delimited by slash
  #'env_context' => true,
  #'key' => 'hash/path/to/app_id',  # real hash path: "/#{node.chef_environment}/hash/path/to/app_id"
=end
}
default['supermarket_omnibus']['chef_oauth2_secret_vault_item'] = {
=begin
  'vault' => 'supermarket',
  'name' => 'chef_oauth2_secret',
  # single secret or nested hash secret path delimited by slash
  'env_context' => false,
  'key' => 'secret',  # real hash path: "/secret"
  # or nested hash secret path delimited by slash
  #'env_context' => true,
  #'key' => 'hash/path/to/secret',  # real hash path: "/#{node.chef_environment}/hash/path/to/secret"
=end
}

node.from_file(run_context.resolve_attribute('supermarket-omnibus-cookbook', 'default'))
