name 'concourse'
description 'Concourse'

run_list(
  #'recipe[ssl_cert::server_key_pairs]',
  'role[docker]',
  'recipe[concourse-ci::docker-compose]',
)

#env_run_lists()

#default_attributes()

image = 'concourse/concourse'  # of 'concourse/concourse:2.6.0',...
port = '8080'
concourse_cn = 'concourse.io.example.com'

override_attributes(
  'concourse-ci' => {
    # Not supported yet.
    'with_ssl_cert_cookbook' => false,
    'ssl_cert' => {
      'common_name' => concourse_cn,
    },
    'docker-compose' => {
      'config' => {
        # Version 1 docker-compose format
        'concourse-web' => {
          'image' => image,
          'ports' => [
            #"#{port}:8080",  # If you sepecify no value, Chef will sets '8080:8080'.
          ],
          'environment' => {
            # If you sepecify no value, Chef will sets "http://#{node['ipaddress']}:8080".
            #'CONCOURSE_EXTERNAL_URL' => "http://192.168.1.3:#{port}",
          },
        },
        'concourse-worker' => {
          'image' => image,
        },
      },
    },
  },
  'ssl_cert' => {
    'common_names' => [
      concourse_cn,
    ],
  },
)
