#
# Cookbook Name:: gitlab-grid
# Recipe:: commons
#
# Copyright 2017, whitestar
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#

config = node['gitlab-grid']['gitlab.rb']
#override_config = node.override['gitlab-grid']['gitlab.rb']
force_override_config = node.force_override['gitlab-grid']['gitlab.rb']

if node['gitlab-grid']['with_ssl_cert_cookbook']
  ::Chef::Recipe.send(:include, SSLCert::Helper)
  cn = node['gitlab-grid']['ssl_cert']['common_name']
  force_override_config['external_url'] = config['external_url'].gsub('http://', 'https://')
  force_override_config['nginx']['ssl_certificate'] = server_cert_path(cn)
  force_override_config['nginx']['ssl_certificate_key'] = server_key_path(cn)
end
