$LOAD_PATH.push("#{File.dirname(__FILE__)}/../_lib")
#${chef-repo}/_lib/grid.rb
require 'grid'

name 'pleiades-dn'
description 'Pleiades DataNode node'

run_list(
  'role[node_commons]',
  'role[grid-realm]',
  'role[ganglia-gmond]',
  'role[pleiades-node]'
)

#env_run_lists "prod" => ["recipe[apache2]"], "staging" => ["recipe[apache2::staging]"], "_default" => []

mcast_addr = Grid::CLUSTERS[:pleiades][:datanodes][:mcast_addr]
port = '8649'

default_attributes(
)

override_attributes(
  'ganglia' => {
    # gmond
    'cluster' => {
      'name' => 'DataNode00000',
      'owner' => Grid::DOMAIN
    },
    ## static multi-cast
    'static' => {
      'udp_send_channels' => [
        {
          'mcast_join' => mcast_addr,
          'host' => '',
          'port' => port,
          'ttl' => '1'
        }
      ],
      'udp_recv_channels' => [
        {
          'mcast_join' => mcast_addr,
          'port' => port,
          'bind' => mcast_addr
        }
      ]
    }
=begin
    ## automatic multi/uni-cast
    'gmond_conf_type' => 'automatic',
    'automatic' = {
      'cluster_name_prefix' => 'DataNode', # DataNode#####
      'cast_mode' => 'uni',                # or multi
      'domain' => 'grid.example.com',
      'node_prefix' => 'dn',
      'digit_nums' => '5',       # dn#####
      'padstr' => '0',           # dn00000
      'first_node_num' => '0',   # 1st node:  dn00000.grid.example.com
      'last_node_num'  => '999', # last node: dn00999.grid.example.com
      'head_node_nums' => '2',   # heads of the 1st cluster: dn0000{0..1}.grid.example.com
      'cluster_size' => '40',    # heads of the 2nd cluster: dn0004{0..1}.grid.example.com
      'mcast_join' => mcast_addr, # multi-cast mode only
      'port' => port,
      'ttl' => '1',              # multi-cast mode only
      'bind' => '239.2.11.71'    # multi-cast mode only
    }
=end
  }
)
