$LOAD_PATH.push("#{File.dirname(__FILE__)}/../_lib")
#${chef-repo}/_lib/grid.rb
require 'grid'
require 'rubygems'
require 'bracecomp'

name 'pleiades-gm'
description 'Pleiades ganglia gmetad node'

run_list(
  'role[node_commons]',
  'role[nameservice-client-grid]',
  'role[ganglia-gmond]',
  'role[ganglia-gmetad]',
  'role[ganglia-web]'
)

#env_run_lists "prod" => ["recipe[apache2]"], "staging" => ["recipe[apache2::staging]"], "_default" => []

this_subcluster = Grid::CLUSTERS[:pleiades][:gmetads]
mcast_addr = this_subcluster[:mcast_addr]
port = '8649'
polling_interval = '30'
=begin
# uni-cast
udp_send_channels4ucast = []
this_subcluster[:nodes].first(2).each {|host|
  udp_send_channels4ucast.push(
    {
      'mcast_join' => '',
      'host' => "#{host}.#{Grid::DOMAIN}",
      'port' => port,
      'ttl' => ''
    }
  )
}
=end

# for non-DataNodes
data_sources = []
Grid::CLUSTERS[:pleiades].select{|key| key != :datanodes}.each {|key, cluster|
  data_sources.push(
    {
      :name => cluster[:alias],
      :polling_interval => polling_interval,
      # head nodes: 2
      :address_list => cluster[:nodes].first(2).map{|host| "#{host}.#{Grid::DOMAIN}"}
    }
  )
}

# for DataNodes
head_node_nums = 2
digit_nums = 5
padstr = '0'
dn_data_sources = []
(0...2).step(40) {|v|
#(0...80).step(40) {|v|
  first_head = v.to_s.rjust(digit_nums, padstr)
  last_head = (v + head_node_nums -1).to_s.rjust(digit_nums, padstr)
  dn_data_sources.push( 
    {
      :name => "DataNode#{first_head}",
      :polling_interval => polling_interval,
      :address_list => "dn{#{first_head}..#{last_head}}.#{Grid::DOMAIN}".expand
    }
  )
}

default_attributes(
  'ganglia' => {
    'web' => {
      'Allow' => [
        "from .#{Grid::DOMAIN}",
        'from 192.168.0.0/16'],
      'AuthType' => 'Kerberos',
      'mod_auth_kerb' => {
        'KrbAuthRealms' => Grid::REALM,
        'Krb5Keytab' => '/etc/krb5.keytab'
      }
    }
  },
)

override_attributes(
  'ganglia' => {
    # gmond
    'cluster' => {
      'name' => this_subcluster[:alias],
      'owner' => Grid::DOMAIN
    },
    ## static multi-cast
    'static' => {
      'udp_send_channels' => [
        {
          'mcast_join' => mcast_addr,
          'host' => '',
          'port' => port,
          'ttl' => '1'
        }
      ],
      'udp_recv_channels' => [
        {
          'mcast_join' => mcast_addr,
          'port' => port,
          'bind' => mcast_addr
        }
      ],
=begin
      ## static uni-cast
      'udp_send_channels' => udp_send_channels4ucast,
      'udp_recv_channels' => [
        {
          'mcast_join' => '',
          'port' => port,
          'bind' => ''
        }
      ],
=end
    },
    # gmetad
    'gridname' => 'Pleiades',
    'trusted_hosts' => ['127.0.0.1'] \
      + Grid::CLUSTERS[:pleiades][:nagioses][:nodes].map{|host| "#{host}.#{Grid::DOMAIN}"},
    'data_sources' => data_sources + dn_data_sources
  }
)
