/*
 * MessageDialogUITest.java
 * JUnit based test
 *
 * Created on 2007/08/14, 15:22
 */

package org.jent.checksmtp;

import junit.framework.*;

/**
 *
 * @author tkyn
 */
public class MessageDialogUITest extends TestCase {
  
  public MessageDialogUITest(String testName) {
    super(testName);
  }
  
  //Detail Open/Close それぞれの時のダイアログの大きさ
  static int openUiHeight = -1;
  static int closeUiHeight = -1;
  
  private void setupStaticVar() {
    if ( openUiHeight > 0 ) { //正数が入っていたら既に設定済みだと思う。
      return;
    }
    
    //まずは、Detail Open/Close時のダイアログの高さを保存しておく、
    //このテストを一番最初に実行する必要がある。
    Exception ex = new Exception();
    MessageDialogUI openUi = new MessageDialogUI("Detail Open/Close test", ex, 0);
    openUi.setDetailOpen(true);
    
    openUi.setDetailOpen(false); //This method effort for Class variable.
    MessageDialogUI closeUi = new MessageDialogUI("Detail Open/Close test", ex, 0);
    
    openUiHeight = openUi.getHeight();
    closeUiHeight = closeUi.getHeight();
    
    openUi.dispose();
    closeUi.dispose();
    
    openUi.setDetailOpen(true);
  }
  
  protected void setUp() throws Exception {
    System.out.println("setup()");
  }
  
  protected void tearDown() throws Exception {
  }
  
  private void sleep(long millsec) {
    try {
      Thread.sleep(millsec);
    } catch (InterruptedException ex) {
      ex.printStackTrace();
    }
  }
  
  private void wait(MessageDialogUI ui) {
    System.out.print("Wait 30s:");
    for(int i=0;i<30;i++) {
      sleep(1000);
      System.out.print(".");
      if ( !ui.isVisible() ) {
        break;
      }
    }
    System.out.println(" OK");
    if ( ui.isVisible() ) {
      ui.dispose();
      fail("Forget human check. This unit test need to human decide.");
    }
  }
  
  public void testDetailOpenClose() {
    setupStaticVar();
    
    //取得したダイアログの高さの確認
    if ( openUiHeight == 0 || closeUiHeight == 0 ) {
      fail("Dialog Height is wrong");
    }
    if ( openUiHeight <= closeUiHeight ) {
      fail("Detail Open/Close no diffrent.");
    }
  }
  
  public void testErrorAndException() {
    //setupStaticVar();
    MessageDialogUI ui = new MessageDialogUI("Check Title `Error` and  Exception, Push OK",
            new Exception("TEST Exception"), MessageDialogUI.ERROR_MODE);
    if ( ui.getHeight() <= closeUiHeight || ui.getHeight() > openUiHeight ) {
      fail("Dialog height is wrong.");
    }
    if ( ui.getTitle().indexOf("Error") < 0 && ui.getTitle().indexOf("エラー") < 0 ) {
      fail("Dialog title is wrong.");
    }
    wait(ui);
  }
  
  
  public void testInfoNoException() {
    //setupStaticVar();
    MessageDialogUI ui = new MessageDialogUI("Check Title 'Information' and no Exception, Push OK",
            null, MessageDialogUI.INFORMATION_MODE);
    if ( ui.getHeight() >= openUiHeight || ui.getHeight() < closeUiHeight  ) {
      fail("Dialog height is wrong.");
    }
    if ( ui.getTitle().indexOf("Information") < 0 && ui.getTitle().indexOf("情報") < 0 ) {
      fail("Dialog title is wrong.");
    }
    wait(ui);
  }
  
  public void testWarningNoException() {
    //setupStaticVar();
    MessageDialogUI ui = new MessageDialogUI("Check Title `Warning` and no Exception, Push OK",
            null, MessageDialogUI.WARNING_MODE);
    if ( ui.getHeight() >= openUiHeight || ui.getHeight() < closeUiHeight ) {
      fail("Dialog height is wrong.");
    }
    if ( ui.getTitle().indexOf("Warning") < 0 && ui.getTitle().indexOf("警告") < 0 ) {
      fail("Dialog title is wrong.");
    }
    wait(ui);
  }
  
}
