/*
 * Decompiled with CFR 0.152.
 */
package org.jent.checksmtp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.Socket;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.regex.Pattern;
import org.jent.checksmtp.ApplicationProperties;
import org.jent.checksmtp.LDAPSearch;
import org.jent.checksmtp.ResultNotify;
import org.jent.checksmtp.SmtpBufferedWriter;
import org.jent.checksmtp.ToListDialog;

public class Processer
implements ResultNotify,
Runnable {
    private Socket client;
    private final int RESULT_UNKNOWN;
    private final int RESULT_OK;
    private final int RESULT_NG;
    private int result;
    private final int R354StartInput;
    private final int R221ServiceClosing;
    private final int R451RequestedActionAbort;
    private final int R502CommandNotImplemented;
    private final String COMMAND_RCPT_TO;
    private final String COMMAND_DATA;
    private final String COMMAND_RESET;
    private final String COMMAND_TURN;

    void $init$() {
        this.RESULT_UNKNOWN = 0;
        this.RESULT_OK = 1;
        this.RESULT_NG = 2;
        this.result = 0;
        this.R354StartInput = 354;
        this.R221ServiceClosing = 221;
        this.R451RequestedActionAbort = 451;
        this.R502CommandNotImplemented = 502;
        this.COMMAND_RCPT_TO = "RCPT TO:";
        this.COMMAND_DATA = "DATA";
        this.COMMAND_RESET = "RSET";
        this.COMMAND_TURN = "TURN";
    }

    public Processer(Socket client) {
        this.$init$();
        this.client = client;
    }

    public void run() {
        Socket server = null;
        try {
            try {
                String servername = ApplicationProperties.getSmtpServerHost();
                int serverport = ApplicationProperties.getSmtpServerPort();
                server = new Socket(servername, serverport);
                InputStream serverInput = server.getInputStream();
                OutputStream serverOutput = server.getOutputStream();
                InputStream clientInput = this.client.getInputStream();
                OutputStream clientOutput = this.client.getOutputStream();
                BufferedReader serverReader = new BufferedReader(new InputStreamReader(server.getInputStream()));
                PrintWriter serverWriter = new PrintWriter((Writer)new SmtpBufferedWriter(new OutputStreamWriter(server.getOutputStream(), "ISO-8859-1")), true);
                BufferedReader clientReader = new BufferedReader(new InputStreamReader(this.client.getInputStream()));
                PrintWriter clientWriter = new PrintWriter((Writer)new SmtpBufferedWriter(new OutputStreamWriter(this.client.getOutputStream(), "ISO-8859-1")), true);
                this.smtpStart(serverReader, clientWriter, clientReader, serverWriter);
                server.close();
                server = null;
                this.client.close();
                this.client = null;
            }
            catch (IOException e) {
                System.err.println("Execption occurred in Processer.");
                e.printStackTrace();
            }
        }
        finally {
            if (server != null) {
                try {
                    server.close();
                }
                catch (IOException ioEx) {}
            }
            if (this.client != null) {
                try {
                    this.client.close();
                }
                catch (IOException ioEx) {}
            }
            LDAPSearch.close();
        }
    }

    private int getCode(String s) {
        return Integer.parseInt(s.substring(0, 3));
    }

    private boolean isContinue(String s) {
        return '-' == s.charAt(3);
    }

    private boolean isRcptTo(String s) {
        return s.startsWith("RCPT TO:");
    }

    private boolean isData(String s) {
        return s.startsWith("DATA");
    }

    private boolean isTurn(String s) {
        return s.startsWith("TURN");
    }

    public void sayOK() {
        this.result = 1;
        this.notifyResult();
    }

    public void sayNG() {
        this.result = 2;
        this.notifyResult();
    }

    private synchronized void notifyResult() {
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void smtpStart(BufferedReader serverReader, PrintWriter clientWriter, BufferedReader clientReader, PrintWriter serverWriter) {
        try {
            ArrayList<String> toList = new ArrayList<String>();
            while (true) {
                String line = serverReader.readLine();
                clientWriter.println(line);
                System.out.println(line);
                if (this.isContinue(line)) continue;
                if (221 != this.getCode(line)) {
                    if (354 == this.getCode(line)) {
                        System.out.println("Send mail data.");
                        do {
                            line = clientReader.readLine();
                            serverWriter.println(line);
                        } while (!line.equals("."));
                        continue;
                    }
                    while ((line = clientReader.readLine()) != null) {
                        if (this.isRcptTo(line)) {
                            toList.add(this.formatToAddress(line));
                            break;
                        }
                        if (this.isTurn(line)) {
                            System.err.println("'TURN' is unsupported command.");
                            clientWriter.println(502);
                            continue;
                        }
                        if (!this.isData(line)) break;
                        ListIterator iterater = toList.listIterator();
                        while (iterater.hasNext()) {
                            System.out.println("ADDRESS CHECK:" + iterater.next());
                        }
                        new ToListDialog(this, toList);
                        while (this.result == 0) {
                            try {
                                Processer processer = this;
                                synchronized (processer) {
                                    this.wait();
                                }
                            }
                            catch (InterruptedException e) {
                                System.err.println("Dialg wait interrupted");
                                e.printStackTrace();
                            }
                        }
                        if (this.result == 1) break;
                        System.out.println("CANCEL sending mail.");
                        serverWriter.println("RSET");
                        line = serverReader.readLine();
                        System.out.println("RSET:ANSER is " + line);
                        clientWriter.println(451);
                    }
                    if (line != null) {
                        serverWriter.println(line);
                        System.out.println(line);
                        continue;
                    }
                }
                break;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("End of Session.");
    }

    private String formatToAddress(String line) {
        System.out.println("FIND To: " + line);
        String str = line.substring("RCPT TO:".length() + 1);
        Pattern pattern = Pattern.compile("[< >]+");
        String[] address = pattern.split(str);
        int i = 0;
        while (i < address.length) {
            if (!address[i].equals("")) break;
            ++i;
        }
        str = address[i] + " " + LDAPSearch.search(address[i]);
        return str;
    }
}

