package org.jent.checksmtp;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;


/**
 * BufferedWriter for SMTP.
 * BufferedWriter is use line.separator properties.
 * SMTP connection use CRLF in end of line.
 */
public class SmtpBufferedWriter extends BufferedWriter {
  private final String CRLF = "\r\n";
  private final String LF = "\n";
  private Writer out;

  public SmtpBufferedWriter(Writer out) {
    super(out);
    this.out = out;
  }

  public SmtpBufferedWriter(Writer out, int sz) {
    super(out, sz);
    this.out = out;
  }

  public void newLine() throws IOException {
    out.write(CRLF);
  }

  /**
   * @param str
   * @throws IOException
   */
  public void write(String str) throws IOException {
    if (str.equals(LF)) {
      str = CRLF;
    }
    write(str, 0, str.length());
  }
}
