package org.jent.checksmtp;

import java.io.IOException;
import java.net.BindException;

import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;


public class SMTPclient implements Runnable {
  private boolean isConfigChange = false;
  private boolean fatalError = false;
  private Thread serviceThread = null;
  
  public SMTPclient() {
    startServiceThread();
  }
  
  private void startServiceThread() {
    if ( serviceThread !=null && serviceThread.isAlive() ) {
      //Still service thread was working.
      return;
    }
    //Reset flags and start service thread.
    isConfigChange = false;
    fatalError = false;
    serviceThread = new Thread(this);
    serviceThread.start();
  }
  
  public void configChangeNotify() {
    isConfigChange = true;
    if ( serviceThread !=null && !serviceThread.isAlive() ) {
      startServiceThread();
    }
  }
  
  public void run() {
    while (!fatalError) {
      ServerSocket server = null;
      
      try {
        //  Server Port
        int serverport = ApplicationProperties.getSmtpPort();
        System.err.println("Open SMTP waiting port. " + serverport);
        
        try {
          if ( ApplicationProperties.getSmtpEnebleRemoteConnect() ) {
            System.out.println("Enable remote connection.");
            server = new ServerSocket(serverport, 10); //TODO: Backlog Configuable
          } else {
            server = new ServerSocket(serverport, 10,  //TODO: Backlog Configuable
                    InetAddress.getByAddress(
                    new byte[] { 127, 0, 0, 1 }));
          }
        } catch (BindException bindEx) {
          fatalError = true;
          String errorMessage = java.util.ResourceBundle.getBundle("org/jent/checksmtp/Bundle").getString("SMTPClient.error.Recive_Port_bind_error") + bindEx.getMessage();
          System.err.println(errorMessage);
          bindEx.printStackTrace();
          new MessageDialogUI(errorMessage, bindEx, MessageDialogUI.ERROR_MODE);
          break;
        } catch (IOException e) {
          fatalError = true;
          String errorMessage = java.util.ResourceBundle.getBundle("org/jent/checksmtp/Bundle").getString("SMTPClient.error.IO_Error_Occurred");
          System.err.println(errorMessage);
          e.printStackTrace();
          new MessageDialogUI(errorMessage, e, MessageDialogUI.ERROR_MODE);
          break;
        } catch (IllegalArgumentException iaEx) {
          //Port value out of range
          fatalError = true;
          String errorMessage = java.util.ResourceBundle.getBundle("org/jent/checksmtp/Bundle").getString("SMTPClient.error.Argument_Error_Occurted") + iaEx.getMessage();
          System.err.println(errorMessage);
          iaEx.printStackTrace();
          new MessageDialogUI(errorMessage, iaEx, MessageDialogUI.ERROR_MODE);
          break;
        }
        
        acceptWait:
          while (true) {
          // Wait connect from mail client
          server.setSoTimeout(1000); //TODO: Configuable accept wait time.
          Socket client;
          try {
            client = server.accept();
          } catch (SocketTimeoutException ex) {
            //Check interupt
            if ( isConfigChange ) {
              System.err.println("Configuration change restart service.");
              isConfigChange = false;
              server.close();
              break; // renew ServerSocket
            }
            continue;
          }
          System.err.println("Accept new STMP socket.");
          Processer processer = new Processer(client);
          Thread clientThread = new Thread(processer);
          clientThread.start();
          }
      } catch (IOException e) {
        e.printStackTrace();
        System.err.println("Continure waiting SMTP client.");
        
        try {
          server.close();
        } catch (IOException ioe) {
          //IGNORE close Exception
        }
      } catch (RuntimeException rEx) {
        fatalError = true;
        String errorMessage = java.util.ResourceBundle.getBundle("org/jent/checksmtp/Bundle").getString("SMTPCLient.error.Runtime_Exception_was_occurred");
        System.err.println(errorMessage);
        new MessageDialogUI(errorMessage, rEx, MessageDialogUI.ERROR_MODE);
        break;
      }
    }
    if ( !fatalError ) {
      //Servce stop by non fatal error. Unexpected.
      String errorMessage = java.util.ResourceBundle.getBundle("org/jent/checksmtp/Bundle").getString("SMTPClient.error.Unexpected_service_stoping_ocurreed");
      System.err.println(errorMessage);
      new MessageDialogUI(errorMessage, null, MessageDialogUI.ERROR_MODE);
    }
  }
}
