package org.jent.checksmtp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;

/*
 * Socket accept proceed
 */
import java.io.OutputStreamWriter;
import java.io.PrintWriter;

import java.net.Socket;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;

import java.util.ArrayList;
import java.util.ListIterator;
import java.util.regex.Pattern;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.jent.checksmtp.ssl.RespondingX509TrustManager;


public class Processer implements Runnable, ResultNotify {
  private Socket client;

  //Conform status.
  private final int RESULT_UNKNOWN = 0;
  private final int RESULT_OK = 1;
  private final int RESULT_NG = 2;
  private int result = RESULT_UNKNOWN;

  //SMTP result code
  private final int R354StartInput = 354;
  private final int R221ServiceClosing = 221;
  private final int R451RequestedActionAbort = 451;
  private final int R502CommandNotImplemented = 502;
  
  //private final int R500SyntexErrorInCommand = 500;
  //private final int R501SyntaxErrorInArguments = 501;
  //private final int R503BadSequenceOfCommands = 503:
  //private final int R504CommandParameterNotImplemented = 504:
  //private final int R211SystemStatusRepl = 211;
  //private final int R214HelpMessage = 214;
  //private final int R220ServiceReady = 220;
  //private final int R421ClosingTransmissionChannel = 421;
  //private final int R250RequestedActionCompleted = 250;
  //private final int R251UserNotLocal = 251;
  //private final int R252CannotVRFYuser = 252;
  //private final int R450RequestedMailActionNotTaken = 450;
  //private final int R550RequestedActionNotTaken = 550;
  //private final int R551UserNotLocal = 551;
  //private final int R452RequestedActionNotTaken = 452;
  //private final int R552RequestedMailActionAborted = 552;
  //private final int R553RequestedActionNotTaken = 553;
  //private final int R554TransactionFailed = 554;
  
  //SMTP command
  private final String COMMAND_RCPT_TO = "RCPT TO:"; // NOI18N
  private final String COMMAND_DATA = "DATA"; // NOI18N
  private final String COMMAND_RESET = "RSET"; // NOI18N
  private final String COMMAND_TURN = "TURN"; // NOI18N

  private final String COMMAND_NOOP = "NOOP";
  //private final String COMAMND_QUIT = "QUIT";
  
  //private final String COMMAND_EXHELLO = "EHLO";
  //private final String COMMAND_HELLO = "HELO";
  //private final String COMMAND_MAIL = "MAIL FROM:";
  //private final String COMMAND_VERIFY = "VRFY";
  //private final String COMMAND_EXPAND = "EXPN";
  //private final String COMMAND_HELP = "HELP";
  public Processer(Socket client) {
      this.client = client;
  }

  public void run() {
    InputStream serverInput;
    OutputStream serverOutput;
    InputStream clientInput;
    OutputStream clientOutput;

    BufferedReader serverReader;
    PrintWriter serverWriter;
    BufferedReader clientReader;
    PrintWriter clientWriter;

    SocketFactory socketFactory = null;
    Socket server = null;
      
    try {
      //Connect to SMTP Server host 
      String servername = ApplicationProperties.getSmtpServerHost();

      //SMTP Server port 
      int serverport = ApplicationProperties.getSmtpServerPort();

      if ( ApplicationProperties.getSmtpServerSSL() ) {
        //SMTP Server use SSL
        System.out.println("SMTP Server use SSL.");
        //socketFactory = SSLSocketFactory.getDefault();
        //OreOre server connection support TrustManager setting.
        try {
          SSLContext sslContext = SSLContext.getInstance("TLS"); //SSL,TLS,TLSv1.1
          sslContext.init(null,
                new TrustManager[]{ new RespondingX509TrustManager()  }, null);
          socketFactory = sslContext.getSocketFactory();
        } catch (NoSuchAlgorithmException nsaEx ) {//from SSLContext.getDefault()
          //TODO: Error dialog
          nsaEx.printStackTrace(System.err);
        } catch (KeyManagementException kmEx) {//from SSLContext.init()
          //TODO: Error dialog
          kmEx.printStackTrace(System.err);
        } catch (IllegalStateException isEx) {//from SSLContext.getSocketFactory()
          //TODO: Error dialog
          isEx.printStackTrace(System.err);
        } catch (Exception ex) { //for new RespondingX506TrustManager()
          //TODO: Error dialog
          ex.printStackTrace(System.err);
        }
      } else {
        //SMTP Server is normal Socket.
        socketFactory = SocketFactory.getDefault();
      }

      //Connection to true SMTP server.
      server = socketFactory.createSocket(servername, serverport);
      serverInput = server.getInputStream();
      serverOutput = server.getOutputStream();
      clientInput = client.getInputStream();
      clientOutput = client.getOutputStream();

      serverReader = new BufferedReader(new InputStreamReader(
                  server.getInputStream()));
      serverWriter = new PrintWriter(new SmtpBufferedWriter(
                  new OutputStreamWriter(server.getOutputStream(),
                      "ISO-8859-1")), true); // NOI18N
      clientReader = new BufferedReader(new InputStreamReader(
                  client.getInputStream()));
      clientWriter = new PrintWriter(new SmtpBufferedWriter(
                  new OutputStreamWriter(client.getOutputStream(),
                      "ISO-8859-1")), true); // NOI18N

      smtpStart(serverReader, clientWriter, clientReader, serverWriter);

      //for SMTP Server connection test
      //SocketProxy forServer = new SocketProxy(clientInput, serverOutput, 0);
      //SocketProxy forClient = new SocketProxy(serverInput, clientOutput, 1);
      //Thread forServerThread = new Thread(forServer);
      //Thread forClientThread = new Thread(forClient);
      //forServerThread.start();
      ////Use this ThreadforClientThread.run();
      server.close();
      server = null;
      client.close();
      client = null;
    } catch (IOException e) {
      String errorMessage = java.util.ResourceBundle.getBundle("org/jent/checksmtp/Bundle").getString("Processer.error.Execption_occurred_at_starting_SMTP_thread.");
      System.err.println(errorMessage);
      new MessageDialogUI(errorMessage, e, MessageDialogUI.ERROR_MODE);
    } catch (RuntimeException runEx) {
      new MessageDialogUI(java.util.ResourceBundle.getBundle("org/jent/checksmtp/Bundle").getString("Processer.error.Runtime_Exception_occurred_in_SMTP_parse"),
              runEx, MessageDialogUI.ERROR_MODE);
    } finally {
      //for failsafe Socket close.
      if (server != null) { 
        try { 
          server.close();
        } catch (IOException ioEx ) {
          //IGNORE close Exception
        }
      }
      if (client != null) { 
        try {
          client.close();
        } catch (IOException ioEx ) {
          //IGNORE close Exception
        }
      }
      //LDAP Connection close.
      LDAPSearch.close();
    }
  }

  private int getCode(String s) {
    int code = 0;
    try {
      code = Integer.parseInt(s.substring(0, 3));
    } catch (NumberFormatException nfEx) {
      code = -1;  //Unexpected: SMTP CODE is allway 3digits.
    }
    return code;
  }

  private boolean isCompliteCode(int code) {
    return code >=200 && code<=299 ;
  }
  
  private boolean isErrorCode(int code) {
    return code>=400 && code<=599;
  }  
  
  private boolean isContinue(String s) {
      if ('-' == s.charAt(3)) {
          return true;
      }

      return false;
  }

  private boolean isRcptTo(String s) {
      if (s.startsWith(COMMAND_RCPT_TO)) {
          return true;
      }

      return false;
  }

  private boolean isData(String s) {
      if (s.startsWith(COMMAND_DATA)) {
          return true;
      }

      return false;
  }

  private boolean isTurn(String s) {
      if (s.startsWith(COMMAND_TURN)) {
          return true;
      }

      return false;
  }

  public void sayOK() {
      result = RESULT_OK;
      notifyResult();
  }

  public void sayNG() {
      result = RESULT_NG;
      notifyResult();
  }

  private synchronized void notifyResult() {
      notify();
  }

  private void smtpStart(BufferedReader serverReader,
    PrintWriter clientWriter, BufferedReader clientReader,
    PrintWriter serverWriter) {
    String line;

    try {
      ArrayList toList = new ArrayList();

      while (true) {
        //Server responce
        line = serverReader.readLine();
        clientWriter.println(line);
        System.out.println(line);

        if (isContinue(line)) {
          continue; //Server responce continue
        }

        //Client request
        if (R221ServiceClosing == getCode(line)) {
          break; //end of session.
        } else if (R354StartInput == getCode(line)) {
          System.out.println("Send mail data.");

          while (true) {
            line = clientReader.readLine();
            serverWriter.println(line);

            if (line.equals(".")) { // NOI18N
              break; //end of mail dara.
            }
          }
        } else {
          while (true) {
            line = clientReader.readLine();

            if (line == null) {
              //Finish client stream.
              System.err.println("Client disconnected.");
              break; //force disconnect.
            }

            if (isRcptTo(line)) {
              //stored To: address.
              toList.add(formatToAddress(line));
            } else if (isTurn(line)) {
              System.err.println("'TURN' is unsupported command.");
              clientWriter.println(R502CommandNotImplemented);

              continue; //read next client request.
            } else if (isData(line)) {
              //Client want to send data. Check out toList.
              ListIterator iterater = toList.listIterator();

              while (iterater.hasNext()) {
                System.out.println("ADDRESS CHECK:" + iterater.next());
              }

              //checkout toList
              result = RESULT_UNKNOWN; //refresh RESULT flag.
              new ToListUI(this, toList);

              while (result == RESULT_UNKNOWN) {
                try {
                    synchronized (this) {
                        wait(4000); //TODO: Configurable NOOP time
                        //Dummy SMTP server access while ToListUI dialog wait.
                        serverWriter.println(COMMAND_NOOP);
                        String serverReply = serverReader.readLine();
                        System.out.println(COMMAND_NOOP + ":ANSER is " + serverReply);
                        //Server MUST retrun "250 OK" by NOOP command.
                        if ( isErrorCode(getCode(serverReply)) ) {
                          System.err.println("Fatal Error. Server return error code by NOOP command.");
                          //Ignore Fatal Error.
                        }
                    }
                } catch (InterruptedException e) {
                    System.err.println("Confirm dialog wait interrupted");
                    e.printStackTrace();
                }
              }
              toList = new ArrayList(); //refresh TO address list.
              
              if (result != RESULT_OK ) {
                System.out.println("CANCEL sending mail.");
                serverWriter.println(COMMAND_RESET);
                line = serverReader.readLine(); //Server MUST retrun "250 OK"
                System.out.println(COMMAND_RESET + ":ANSER is " + line);
                if ( isErrorCode(getCode(line)) ) {
                  System.err.println("Fatal Error. Server return error code by RESET command.");
                  //Ignore Fatal Error.
                }
                clientWriter.println(R451RequestedActionAbort);

                continue; //I think Client QUIT or Retry. 
              }
            }

            break; // client read while(true);
          }

          if (line == null ) {
            break;
          }
          serverWriter.println(line);
          System.out.println(line);
        }
      }
    } catch (IOException e) {
      String errorMessage = java.util.ResourceBundle.getBundle("org/jent/checksmtp/Bundle").getString("Processer.error.Error_occurred_in_SMTP_parse.");
      System.err.println(errorMessage);
      new MessageDialogUI(errorMessage, e, MessageDialogUI.ERROR_MODE);
    } catch (RuntimeException runEx) {
      new MessageDialogUI(java.util.ResourceBundle.getBundle("org/jent/checksmtp/Bundle").getString("Processer.error.Runtime_Exception_occurred_in_SMTP_parse"),
              runEx, MessageDialogUI.ERROR_MODE);
    }

    System.out.println("End of Session.");
  }

  private String formatToAddress(String line) {
    System.out.println("FIND To: " + line);

    //Splitting Mail address.
    String str = line.substring(COMMAND_RCPT_TO.length() + 1);
    Pattern pattern = Pattern.compile("[< >]+"); // NOI18N
    String[] address = pattern.split(str); // 0<1>2 3
    int i;

    for (i = 0; i < address.length; i++) {
      if (!address[i].equals("")) { // NOI18N
        break;
      }
    }

    //Search LDAP
    str = address[i] + " " + LDAPSearch.search(address[i]); // NOI18N
    return str;
  }
}
