/****************************************************************************
**
** Copyrigh  (C) 2019 alexrayne <alexraynepe196@gmail.com>
** Copyright (C) 2012 Denis Shienkov <denis.shienkov@gmail.com>
** Copyright (C) 2012 Laszlo Papp <lpapp@kde.org>
** Contact: https://www.qt.io/licensing/
**
** This file is part of the QtSerialPort module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:BSD$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** BSD License Usage
** Alternatively, you may use this file under the terms of the BSD license
** as follows:
**
** "Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions are
** met:
**   * Redistributions of source code must retain the above copyright
**     notice, this list of conditions and the following disclaimer.
**   * Redistributions in binary form must reproduce the above copyright
**     notice, this list of conditions and the following disclaimer in
**     the documentation and/or other materials provided with the
**     distribution.
**   * Neither the name of The Qt Company Ltd nor the names of its
**     contributors may be used to endorse or promote products derived
**     from this software without specific prior written permission.
**
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
** "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
** LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
** OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
** SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
** LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
** DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
** THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
** OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE."
**
** $QT_END_LICENSE$
**
****************************************************************************/
/*
 * this terminal was developed from QtSerialPort module of the Qt examples
 * */

#ifndef CONSOLE_H
#define CONSOLE_H

#include <QObject>
#include <QPlainTextEdit>

class Console : public QPlainTextEdit
{
    Q_OBJECT

public:
    explicit Console(QWidget *parent = nullptr);

    void setLocalEdit(bool set);

    void setPrompt(const QString& x){ prompt = x;}

    void scrollDown();

    void mode_insert_toggle();

    const QStringList& history_list() const {return history;};
    void assign_history(const QStringList& x);
    void assign_history(QStringList&& x);

public slots:
    void putData(const QByteArray data);

signals:
    void getData(const QByteArray data);

public:
    typedef QTextCharFormat TextStyle;
    enum StyleID {
        styleCLIENT, styleSERVER, 
        styleTOTAL
    };

    TextStyle&      style(StyleID id){return styles[id];}

protected:
    TextStyle       styles[styleTOTAL];
    void            style_apply(StyleID id);
    void            styles_init(); 

protected:
    void keyPressEvent(QKeyEvent *e) override;
    void mousePressEvent(QMouseEvent *e) override;
    void mouseDoubleClickEvent(QMouseEvent *e) override;
    void contextMenuEvent(QContextMenuEvent *e) override;

    void keyInput(QKeyEvent *e);
    void writeData(const QByteArray& data);
    void onEnter();
    void insertPrompt(bool insertNewBlock = true);
    void output(QString);

    // @arg onoff = true - text receive by client`s keyPressEvent
    //              false - text receive from server
    void input_by_client(bool onoff);

    bool input_cmd = false;
    int  position_cmd;

    class StyleScope {
    public:
        explicit
        StyleScope(Console& x): self(x){
            mode = (x.input_cmd)? styleCLIENT : styleSERVER;
        }
        ~StyleScope() {
            self.style_apply(mode); 
        }
    protected:
        Console&        self;
        StyleID         mode;
    };

private:
    bool localEdit = true;
    QString prompt;

protected:
    void historyAdd(QString);
    void historyDrop();
    void historyDrop(QString);
    void historyBack();
    void historyForward();
    void drop_input();
    
    QStringList history;
    int historyPos;

    //restore overwrite mode when out of scope
    class ModeOverScope {
    public:
        explicit
        ModeOverScope(QPlainTextEdit& x): self(x){mode = x.overwriteMode();}
        ~ModeOverScope(){self.setOverwriteMode(mode); }
    protected:
        QPlainTextEdit& self;
        bool            mode;
    };
};


#endif // CONSOLE_H
