/*
 * compiler-port.h
 *
 *  Created on: 22 . 2016 .
 *      Author: alexrayne <alexraynepe196@gmail.com>
  ------------------------------------------------------------------------
    Copyright (c) alexrayne

   All rights reserved.
   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:
   - Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   - Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
   - Neither the name of ARM nor the names of its contributors may be used
     to endorse or promote products derived from this software without
     specific prior written permission.
   *
   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL COPYRIGHT HOLDERS AND CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE. *
   -------------------------------------------------------------------------
   Linux GCC compat
 */

#ifndef COMPILER_PORT_H_
#define COMPILER_PORT_H_

#ifndef __cplusplus

#if defined ( __GNUC__ ) \
    || defined ( __ICCARM__ )\
    || defined ( __TMS470__ )\
    || defined ( __TASKING__ )
  #define ASM            __asm                                      /*!< asm keyword for GNU Compiler          */
  #define INLINE         static inline                                     /*!< inline keyword for GNU Compiler       */
#endif

#if __STDC_VERSION__ >= 199901L
  #define struct_field(name)    .name =
#else
  #define struct_field(name)
#endif


#else //#ifndef __cplusplus

#   define INLINE inline
#   define struct_field(name)

#endif //#ifndef __cplusplus



#ifndef __HOT
#if defined ( __GNUC__ )
#define __HOT    __attribute__((hot))

/*
 * IAR Compiler
 */
#elif defined ( __ICCARM__ )
#define __HOT    _Pragma("location=\".hot\"")
#else
#define __HOT
#endif
#endif

#ifndef __HOTFUNC
#if defined ( __GNUC__ )
#define __HOTFUNC    __attribute__((hot))
#elif defined ( __ICCARM__ )
/**  IAR Compiler */
#define __HOTFUNC    __ramfunc
#else
#define __HOTFUNC
#endif
#endif



#define ssaturate(x, bits)  __SSAT(x, bits)
#define usaturate(x, bits)  __USAT(x, bits)
#define clz(x)              __clz(x)
#define ctz(x)              __clz(__rbit(x))

#ifdef __CC_ARM
#define bswap32(x)          __REV(x)
#define bswap16(x)          __REV16(x)
#elif defined(__GNUC__)
#define bswap32(x)          __builtin_bswap32(x)
#define bswap16(x)          __builtin_bswap16(x)
#elif defined(__ICCARM__)
#define bswap32(x)          __REV(x)
#define bswap16(x)          __REV16(x)
#endif


#endif /* COMPILER_PORT_H_ */
