#ifndef VT_HAL_HPP
#define VT_HAL_HPP
/*
 * vt_hal.hpp
 *
 *  Created on: 11 янв. 2020 г.
 *      Author: alexrayne <alexraynepe196@gmail.com>
  ------------------------------------------------------------------------
    Copyright (c) alexrayne

   All rights reserved.
   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:
   - Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
   - Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
   - Neither the name of ARM nor the names of its contributors may be used
     to endorse or promote products derived from this software without
     specific prior written permission.
   *
   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED. IN NO EVENT SHALL COPYRIGHT HOLDERS AND CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE. *
  ------------------------------------------------------------------------
 * this is a VirtualTerminal filter over stdio device
 */

#include "hal_device.h"
#include "serial/stdio_hal.hpp"
#include "cli_keys.hpp"

class VTerminalBaseDevice : public StdIO_Device
        //, public HAL_INBlock_Device
        //, public HAL_Device
{
    public:
    typedef StdIO_Device inherited;
    typedef StdIO_Device io_t;

public:
    VTerminalBaseDevice(io_t* _io);
    VTerminalBaseDevice(const_string name, io_t* _io);
    virtual ~VTerminalBaseDevice(){}
    
    //using inherited::init;
    void init(io_t* io);
    
    // reset telnet negotiated state
    virtual void reset();
    
    io_t*   io() const {return _io;}

protected:
    io_t*           _io;

public: // terminal API
    void send_cursor_pos(unsigned x, unsigned y);
    void send_cursor_lf(unsigned x);
    void send_cursor_rt(unsigned x);
    void send_cursor_save();
    void send_cursor_restore();

    enum EraseModeID{
        eraseAFTER=0, //from cursor to end
        erasePRE = 1, //before cursor
        eraseALL = 2, //all screen/line
    };
    void send_erase_line( EraseModeID how = eraseALL);
    void send_erase_screen( EraseModeID how = eraseALL);

protected:
    void send_cursor_move(unsigned x, cli::KeyCode dir);
    void send_csi(char code);
    void send_csi(char code, char mode);

public: // StdIO_Device
    virtual int get_char();
    // @return - amount of availiable data.
    virtual int get_wait(unsigned to = 0);
    // блокирующий прием
    
    //* блокирующая печать
    virtual int putChar(int ch);
    
    //*  неблокирующая печать
    virtual int postData ( const void* str, unsigned len);
    //* блокирующая печать
    virtual int puts( const char* str);
    //*  \return - длинна отправленного участка
    virtual int putData ( const void* str, unsigned len);
    
    //*  ожидание доступности печати
    //*  \return - количество байт возможных для неблокирующей печати
    virtual int put_wait(unsigned to = 0);
    //*  почти тоже put_wait, ждет полного опустошения
    virtual int put_flush(unsigned to = 0);
    //*  очищает буфер, прерывая текущую отправку
    virtual int put_drop();
    
    //* монополизация вывода (puts, putData предпочтительно использую ее )
    //* \arg onoff - захват/освобождение
    //* \return    - состояние захвачн ли вывод
    virtual bool put_access(bool onoff, unsigned to = toInfinite);

protected:
    int             peekchar;
    const char*     peeks;
    enum StreamState{
        ssCHAR, ssESC
        , ssNOCS1, ssNOCS2, ssNOCSO2
        , ssCSI, ssCSO
        , ssCSI4FUN
        //, ssVTKEY , ssVTFUN
    };
    StreamState     st;
    char            vt_key;

    int accepted_state( int ch);
    int rejected_state_pass( const char* collected, char ch);

public: // HAL_INBlock_Device
    //*  \return - длинна полученного участка
    //virtual int getData ( void* dst, unsigned len);
    //*  ожидание amount доступных символов
    //virtual int get_waitfor(unsigned amount, unsigned to = 0);

};

#endif // VT_HAL_HPP
